/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.HashMap;
import toxi.geom.Vec3D;
import toxi.volume.VolumetricSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumetricHashMap
extends VolumetricSpace {
    protected HashMap<Integer, Float> data;
    protected float density;

    public VolumetricHashMap(Vec3D vec3D, int n, int n2, int n3, float f) {
        super(vec3D, n, n2, n3);
        this.density = f;
        this.data = new HashMap((int)((float)(n * n2 * n3) * f));
    }

    @Override
    public void clear() {
        this.data.clear();
        this.data = new HashMap((int)((float)(this.resX * this.resY * this.resZ) * this.density));
    }

    @Override
    public void closeSides() {
        this.setVolumeSidesTo(0.0f);
    }

    public HashMap<Integer, Float> getData() {
        return this.data;
    }

    public float getDensity() {
        return (float)this.data.size() / (float)this.numCells;
    }

    @Override
    public final float getVoxelAt(int n) {
        Float f = this.data.get(n);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public final float getVoxelAt(int n, int n2, int n3) {
        Float f = this.data.get(n + n2 * this.resX + n3 * this.sliceRes);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public void setVolumeSidesTo(float f) {
        int n;
        int n2;
        int n3;
        for (n3 = this.resZ1; n3 > 0; --n3) {
            int n4;
            n2 = n3 * this.sliceRes;
            n = n2 + this.resY1 * this.resX;
            for (n4 = 0; n4 < this.resX; ++n4) {
                this.data.put(n2 + n4, Float.valueOf(f));
                this.data.put(n + n4, Float.valueOf(f));
            }
            int n5 = n2 + this.resX;
            for (n4 = 1; n4 < this.resY1; ++n4) {
                this.data.put(n5, Float.valueOf(f));
                this.data.put(n5 + this.resX1, Float.valueOf(f));
                n5 += this.resX;
            }
        }
        n2 = 0;
        n = this.resZ1 * this.sliceRes;
        for (n3 = 0; n3 < this.sliceRes; ++n3) {
            this.data.put(n2++, Float.valueOf(f));
            this.data.put(n++, Float.valueOf(f));
        }
    }

    @Override
    public final void setVoxelAt(int n, float f) {
        if (n >= 0 && n < this.numCells) {
            this.data.put(n, Float.valueOf(f));
        }
    }

    @Override
    public final void setVoxelAt(int n, int n2, int n3, float f) {
        int n4 = n + n2 * this.resX + n3 * this.sliceRes;
        if (n4 >= 0 && n4 < this.numCells) {
            this.data.put(n4, Float.valueOf(f));
        }
    }
}

