/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.volume.IsoSurface;
import toxi.volume.MarchingCubesIndex;
import toxi.volume.VolumetricSpace;

public class HashIsoSurface
implements IsoSurface {
    protected static final Logger logger = Logger.getLogger(HashIsoSurface.class.getName());
    protected Vec3D cellSize;
    protected Vec3D centreOffset;
    protected VolumetricSpace volume;
    public float isoValue;
    protected int resX;
    protected int resY;
    protected int resZ;
    protected int resX1;
    protected int resY1;
    protected int resZ1;
    protected int sliceRes;
    protected int nextXY;
    protected HashMap<Integer, Vec3D> edgeVertices;
    protected float density;
    protected short[] cellIndexCache;
    protected short[] prevCellIndexCache;

    public HashIsoSurface(VolumetricSpace volumetricSpace) {
        this(volumetricSpace, 0.5f);
    }

    public HashIsoSurface(VolumetricSpace volumetricSpace, float f) {
        this.volume = volumetricSpace;
        this.density = f;
        this.cellSize = new Vec3D(volumetricSpace.scale.x / (float)volumetricSpace.resX1, volumetricSpace.scale.y / (float)volumetricSpace.resY1, volumetricSpace.scale.z / (float)volumetricSpace.resZ1);
        this.resX = volumetricSpace.resX;
        this.resY = volumetricSpace.resY;
        this.resZ = volumetricSpace.resZ;
        this.resX1 = volumetricSpace.resX1;
        this.resY1 = volumetricSpace.resY1;
        this.resZ1 = volumetricSpace.resZ1;
        this.sliceRes = volumetricSpace.sliceRes;
        this.nextXY = this.resX + this.sliceRes;
        this.cellIndexCache = new short[this.sliceRes];
        this.prevCellIndexCache = new short[this.sliceRes];
        this.centreOffset = volumetricSpace.halfScale.getInverted();
        this.reset();
    }

    public Mesh3D computeSurfaceMesh(Mesh3D mesh3D, float f) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("isosurface-" + f);
        } else {
            mesh3D.clear();
        }
        this.isoValue = f;
        float f2 = this.centreOffset.z;
        for (int i = 0; i < this.resZ1; ++i) {
            int n = this.sliceRes * i;
            float f3 = this.centreOffset.y;
            for (int j = 0; j < this.resY1; ++j) {
                float f4 = this.centreOffset.x;
                int n2 = this.resX * j;
                int n3 = n2 + n;
                for (int k = 0; k < this.resX1; ++k) {
                    int n4;
                    int n5 = this.getCellIndex(k, j, i);
                    this.cellIndexCache[n2 + k] = (short)n5;
                    if (n5 > 0 && n5 < 255 && (n4 = MarchingCubesIndex.edgesToCompute[n5]) > 0 && n4 < 255) {
                        float f5;
                        int n6 = n3 * 3;
                        float f6 = this.volume.getVoxelAt(n3);
                        float f7 = this.isoValue - f6;
                        if ((n4 & 1) > 0) {
                            f5 = f7 / (this.volume.getVoxelAt(n3 + 1) - f6);
                            this.edgeVertices.put(n6, new Vec3D(f4 + f5 * this.cellSize.x, (float)j * this.cellSize.y + this.centreOffset.y, (float)i * this.cellSize.z + this.centreOffset.z));
                        }
                        if ((n4 & 2) > 0) {
                            f5 = f7 / (this.volume.getVoxelAt(n3 + this.resX) - f6);
                            this.edgeVertices.put(n6 + 1, new Vec3D((float)k * this.cellSize.x + this.centreOffset.x, f3 + f5 * this.cellSize.y, (float)i * this.cellSize.z + this.centreOffset.z));
                        }
                        if ((n4 & 4) > 0) {
                            f5 = f7 / (this.volume.getVoxelAt(n3 + this.sliceRes) - f6);
                            this.edgeVertices.put(n6 + 2, new Vec3D((float)k * this.cellSize.x + this.centreOffset.x, (float)j * this.cellSize.y + this.centreOffset.y, f2 + f5 * this.cellSize.z));
                        }
                    }
                    f4 += this.cellSize.x;
                    ++n3;
                }
                f3 += this.cellSize.y;
            }
            if (i > 0) {
                this.createFacesForSlice(mesh3D, i - 1);
            }
            short[] sArray = this.prevCellIndexCache;
            this.prevCellIndexCache = this.cellIndexCache;
            this.cellIndexCache = sArray;
            f2 += this.cellSize.z;
        }
        this.createFacesForSlice(mesh3D, this.resZ1 - 1);
        return mesh3D;
    }

    private void createFacesForSlice(Mesh3D mesh3D, int n) {
        int n2;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("creating polygons for slice: " + n);
        }
        int[] nArray = new int[16];
        int n3 = this.sliceRes * n;
        for (n2 = 0; n2 < this.resY1; ++n2) {
            int n4 = this.resX * n2;
            for (int i = 0; i < this.resX1; ++i) {
                short s = this.prevCellIndexCache[n4];
                if (s > 0 && s < 255) {
                    int n5;
                    int n6 = 0;
                    int[] nArray2 = MarchingCubesIndex.cellTriangles[s];
                    while ((n5 = nArray2[n6]) != -1) {
                        int[] nArray3 = MarchingCubesIndex.edgeOffsets[n5];
                        nArray[n6] = (i + nArray3[0] + this.resX * (n2 + nArray3[1]) + this.sliceRes * (n + nArray3[2])) * 3 + nArray3[3];
                        ++n6;
                    }
                    for (int j = 0; j < n6; j += 3) {
                        Vec3D vec3D;
                        Vec3D vec3D2;
                        Vec3D vec3D3 = this.edgeVertices.get(nArray[j + 1]);
                        if (vec3D3 == null || (vec3D2 = this.edgeVertices.get(nArray[j + 2])) == null || (vec3D = this.edgeVertices.get(nArray[j])) == null) continue;
                        mesh3D.addFace(vec3D3, vec3D2, vec3D);
                    }
                }
                ++n4;
            }
        }
        n2 = n3 * 3;
        Iterator<Map.Entry<Integer, Vec3D>> iterator = this.edgeVertices.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getKey() >= n2) continue;
            iterator.remove();
        }
    }

    protected final int getCellIndex(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n + n2 * this.resX + n3 * this.sliceRes;
        if (this.volume.getVoxelAt(n5) < this.isoValue) {
            n4 |= 1;
        }
        if (this.volume.getVoxelAt(n5 + this.sliceRes) < this.isoValue) {
            n4 |= 8;
        }
        if (this.volume.getVoxelAt(n5 + this.resX) < this.isoValue) {
            n4 |= 0x10;
        }
        if (this.volume.getVoxelAt(n5 + this.resX + this.sliceRes) < this.isoValue) {
            n4 |= 0x80;
        }
        if (this.volume.getVoxelAt(++n5) < this.isoValue) {
            n4 |= 2;
        }
        if (this.volume.getVoxelAt(n5 + this.sliceRes) < this.isoValue) {
            n4 |= 4;
        }
        if (this.volume.getVoxelAt(n5 + this.resX) < this.isoValue) {
            n4 |= 0x20;
        }
        if (this.volume.getVoxelAt(n5 + this.resX + this.sliceRes) < this.isoValue) {
            n4 |= 0x40;
        }
        return n4;
    }

    public void reset() {
        this.edgeVertices = new HashMap((int)(this.density * (float)this.volume.numCells));
    }

    public void setExpectedDensity(float f) {
        this.density = f;
    }
}

