/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.volume.IsoSurface;
import toxi.volume.MarchingCubesIndex;
import toxi.volume.VolumetricSpace;

public class ArrayIsoSurface
implements IsoSurface {
    protected static final Logger logger = Logger.getLogger(ArrayIsoSurface.class.getName());
    protected Vec3D cellSize;
    protected Vec3D centreOffset;
    protected VolumetricSpace volume;
    public float isoValue;
    protected int resX;
    protected int resY;
    protected int resZ;
    protected int resX1;
    protected int resY1;
    protected int resZ1;
    protected int sliceRes;
    protected int nextXY;
    protected Vec3D[] edgeVertices;

    public ArrayIsoSurface(VolumetricSpace volumetricSpace) {
        this.volume = volumetricSpace;
        this.cellSize = new Vec3D(volumetricSpace.scale.x / (float)volumetricSpace.resX1, volumetricSpace.scale.y / (float)volumetricSpace.resY1, volumetricSpace.scale.z / (float)volumetricSpace.resZ1);
        this.resX = volumetricSpace.resX;
        this.resY = volumetricSpace.resY;
        this.resZ = volumetricSpace.resZ;
        this.resX1 = volumetricSpace.resX1;
        this.resY1 = volumetricSpace.resY1;
        this.resZ1 = volumetricSpace.resZ1;
        this.sliceRes = volumetricSpace.sliceRes;
        this.nextXY = this.resX + this.sliceRes;
        this.centreOffset = volumetricSpace.halfScale.getInverted();
        this.edgeVertices = new Vec3D[3 * volumetricSpace.numCells];
    }

    public Mesh3D computeSurfaceMesh(Mesh3D mesh3D, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("isosurface-" + f);
        } else {
            mesh3D.clear();
        }
        this.isoValue = f;
        float f2 = this.centreOffset.z;
        for (int i = 0; i < this.resZ1; ++i) {
            n6 = this.sliceRes * i;
            float f3 = this.centreOffset.y;
            for (n5 = 0; n5 < this.resY1; ++n5) {
                float f4 = this.centreOffset.x;
                n4 = this.resX * n5 + n6;
                for (n3 = 0; n3 < this.resX1; ++n3) {
                    n2 = this.getCellIndex(n3, n5, i);
                    if (n2 > 0 && n2 < 255 && (n = MarchingCubesIndex.edgesToCompute[n2]) > 0 && n < 255) {
                        float f5;
                        int n7 = n4 * 3;
                        float f6 = this.volume.getVoxelAt(n4);
                        float f7 = this.isoValue - f6;
                        if ((n & 1) > 0 && this.edgeVertices[n7] == null) {
                            f5 = f7 / (this.volume.getVoxelAt(n4 + 1) - f6);
                            this.edgeVertices[n7] = new Vec3D(f4 + f5 * this.cellSize.x, (float)n5 * this.cellSize.y + this.centreOffset.y, (float)i * this.cellSize.z + this.centreOffset.z);
                        }
                        if ((n & 2) > 0 && this.edgeVertices[n7 + 1] == null) {
                            f5 = f7 / (this.volume.getVoxelAt(n4 + this.resX) - f6);
                            this.edgeVertices[n7 + 1] = new Vec3D((float)n3 * this.cellSize.x + this.centreOffset.x, f3 + f5 * this.cellSize.y, (float)i * this.cellSize.z + this.centreOffset.z);
                        }
                        if ((n & 4) > 0 && this.edgeVertices[n7 + 2] == null) {
                            f5 = f7 / (this.volume.getVoxelAt(n4 + this.sliceRes) - f6);
                            this.edgeVertices[n7 + 2] = new Vec3D((float)n3 * this.cellSize.x + this.centreOffset.x, (float)n5 * this.cellSize.y + this.centreOffset.y, f2 + f5 * this.cellSize.z);
                        }
                    }
                    f4 += this.cellSize.x;
                    ++n4;
                }
                f3 += this.cellSize.y;
            }
            f2 += this.cellSize.z;
        }
        int[] nArray = new int[16];
        for (n6 = 0; n6 < this.resZ1; ++n6) {
            int n8 = this.sliceRes * n6;
            for (n5 = 0; n5 < this.resY1; ++n5) {
                int n9 = this.resX * n5 + n8;
                for (n4 = 0; n4 < this.resX1; ++n4) {
                    n3 = this.getCellIndex(n4, n5, n6);
                    if (n3 > 0 && n3 < 255) {
                        n2 = 0;
                        int[] nArray2 = MarchingCubesIndex.cellTriangles[n3];
                        while ((n = nArray2[n2]) != -1) {
                            int[] nArray3 = MarchingCubesIndex.edgeOffsets[n];
                            nArray[n2] = (n4 + nArray3[0] + this.resX * (n5 + nArray3[1]) + this.sliceRes * (n6 + nArray3[2])) * 3 + nArray3[3];
                            ++n2;
                        }
                        for (int i = 0; i < n2; i += 3) {
                            Vec3D vec3D = this.edgeVertices[nArray[i + 1]];
                            Vec3D vec3D2 = this.edgeVertices[nArray[i + 2]];
                            Vec3D vec3D3 = this.edgeVertices[nArray[i]];
                            if (vec3D == null || vec3D2 == null || vec3D3 == null) continue;
                            mesh3D.addFace(vec3D, vec3D2, vec3D3);
                        }
                    }
                    ++n9;
                }
            }
        }
        return mesh3D;
    }

    protected final int getCellIndex(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n + n2 * this.resX + n3 * this.sliceRes;
        if (this.volume.getVoxelAt(n5) < this.isoValue) {
            n4 |= 1;
        }
        if (this.volume.getVoxelAt(n5 + this.sliceRes) < this.isoValue) {
            n4 |= 8;
        }
        if (this.volume.getVoxelAt(n5 + this.resX) < this.isoValue) {
            n4 |= 0x10;
        }
        if (this.volume.getVoxelAt(n5 + this.resX + this.sliceRes) < this.isoValue) {
            n4 |= 0x80;
        }
        if (this.volume.getVoxelAt(++n5) < this.isoValue) {
            n4 |= 2;
        }
        if (this.volume.getVoxelAt(n5 + this.sliceRes) < this.isoValue) {
            n4 |= 4;
        }
        if (this.volume.getVoxelAt(n5 + this.resX) < this.isoValue) {
            n4 |= 0x20;
        }
        if (this.volume.getVoxelAt(n5 + this.resX + this.sliceRes) < this.isoValue) {
            n4 |= 0x40;
        }
        return n4;
    }

    public void reset() {
        for (int i = 0; i < this.edgeVertices.length; ++i) {
            this.edgeVertices[i] = null;
        }
    }
}

