/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryStrategy;

public class TetradTheoryStrategy
implements ColorTheoryStrategy {
    public static final String NAME = "tetrad";
    protected int theta = 90;

    public TetradTheoryStrategy() {
    }

    public TetradTheoryStrategy(int n) {
        this.theta = n;
    }

    public ColorList createListFromColor(ReadonlyTColor readonlyTColor) {
        ColorList colorList = new ColorList(readonlyTColor);
        TColor tColor = readonlyTColor.getRotatedRYB(this.theta);
        if ((double)tColor.brightness() < 0.5) {
            tColor.lighten(0.2f);
        } else {
            tColor.darken(0.2f);
        }
        colorList.add(tColor);
        tColor = readonlyTColor.getRotatedRYB(this.theta * 2);
        if ((double)tColor.brightness() < 0.5) {
            tColor.lighten(0.1f);
        } else {
            tColor.darken(0.1f);
        }
        colorList.add(tColor);
        colorList.add(readonlyTColor.getRotatedRYB(this.theta * 3).lighten(0.1f));
        return colorList;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return NAME;
    }
}

