/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryStrategy;
import toxi.math.MathUtils;

public class CompoundTheoryStrategy
implements ColorTheoryStrategy {
    public static final String NAME = "compound";
    private boolean isFlipped = false;

    private static final float wrap(float f, float f2, float f3, float f4) {
        if (f - f2 < f3) {
            return f + f4;
        }
        return f - f2;
    }

    public CompoundTheoryStrategy() {
    }

    public CompoundTheoryStrategy(boolean bl) {
        this.isFlipped = bl;
    }

    public ColorList createListFromColor(ReadonlyTColor readonlyTColor) {
        ColorList colorList = new ColorList(readonlyTColor);
        int n = this.isFlipped ? -1 : 1;
        TColor tColor = readonlyTColor.getRotatedRYB(30 * n);
        tColor.setBrightness(CompoundTheoryStrategy.wrap(tColor.brightness(), 0.25f, 0.6f, 0.25f));
        colorList.add(tColor);
        tColor = readonlyTColor.getRotatedRYB(30 * n);
        tColor.setSaturation(CompoundTheoryStrategy.wrap(tColor.saturation(), 0.4f, 0.1f, 0.4f));
        tColor.setBrightness(CompoundTheoryStrategy.wrap(tColor.brightness(), 0.4f, 0.2f, 0.4f));
        colorList.add(tColor);
        tColor = readonlyTColor.getRotatedRYB(160 * n);
        tColor.setSaturation(CompoundTheoryStrategy.wrap(tColor.saturation(), 0.25f, 0.1f, 0.25f));
        tColor.setBrightness(MathUtils.max((float)0.2f, (float)tColor.brightness()));
        colorList.add(tColor);
        tColor = readonlyTColor.getRotatedRYB(150 * n);
        tColor.setSaturation(CompoundTheoryStrategy.wrap(tColor.saturation(), 0.1f, 0.8f, 0.1f));
        tColor.setBrightness(CompoundTheoryStrategy.wrap(tColor.brightness(), 0.3f, 0.6f, 0.3f));
        colorList.add(tColor);
        tColor = readonlyTColor.getRotatedRYB(150 * n);
        tColor.setSaturation(CompoundTheoryStrategy.wrap(tColor.saturation(), 0.1f, 0.8f, 0.1f));
        tColor.setBrightness(CompoundTheoryStrategy.wrap(tColor.brightness(), 0.4f, 0.2f, 0.4f));
        return colorList;
    }

    public String getName() {
        return NAME;
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public void setFlipped(boolean bl) {
        this.isFlipped = bl;
    }

    public String toString() {
        return NAME + (this.isFlipped ? "_flipped" : "");
    }
}

