/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryStrategy;

public class ComplementaryStrategy
implements ColorTheoryStrategy {
    public static final String NAME = "complementary";

    public ColorList createListFromColor(ReadonlyTColor readonlyTColor) {
        ColorList colorList = new ColorList(readonlyTColor);
        TColor tColor = readonlyTColor.copy();
        if ((double)tColor.brightness() > 0.4) {
            tColor.setBrightness(0.1f + tColor.brightness() * 0.25f);
        } else {
            tColor.setBrightness(1.0f - tColor.brightness() * 0.25f);
        }
        colorList.add(tColor);
        tColor = readonlyTColor.copy();
        tColor.lighten(0.3f);
        tColor.setSaturation(0.1f + tColor.saturation() * 0.3f);
        colorList.add(tColor);
        tColor = readonlyTColor.getComplement();
        if ((double)tColor.brightness() > 0.3) {
            tColor.setBrightness(0.1f + tColor.brightness() * 0.25f);
        } else {
            tColor.setBrightness(1.0f - tColor.brightness() * 0.25f);
        }
        colorList.add(tColor);
        colorList.add(readonlyTColor.getComplement());
        tColor = readonlyTColor.getComplement();
        tColor.lighten(0.3f);
        tColor.setSaturation(0.1f + tColor.saturation() * 0.25f);
        colorList.add(tColor);
        return colorList;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return NAME;
    }
}

