/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryStrategy;
import toxi.geom.Vec2D;
import toxi.math.MathUtils;

public class AnalogousStrategy
implements ColorTheoryStrategy {
    public static final String NAME = "analogous";
    protected static final Vec2D[] tones = new Vec2D[]{new Vec2D(1.0f, 2.2f), new Vec2D(2.0f, 1.0f), new Vec2D(-1.0f, -0.5f), new Vec2D(-2.0f, 1.0f)};
    protected float contrast = 0.25f;
    protected float theta = 0.17453292f;

    public AnalogousStrategy() {
    }

    public AnalogousStrategy(float f, float f2) {
        this.contrast = f2;
        this.theta = f;
    }

    public AnalogousStrategy(int n, float f) {
        this.contrast = f;
        this.theta = MathUtils.radians((float)n);
    }

    public ColorList createListFromColor(ReadonlyTColor readonlyTColor) {
        this.contrast = MathUtils.clipNormalized((float)this.contrast);
        ColorList colorList = new ColorList(readonlyTColor);
        for (Vec2D vec2D : tones) {
            TColor tColor = readonlyTColor.getRotatedRYB((int)(this.theta * vec2D.x));
            float f = 0.44f - vec2D.y * 0.1f;
            if (readonlyTColor.brightness() - this.contrast * vec2D.y < f) {
                tColor.setBrightness(f);
            } else {
                tColor.setBrightness(readonlyTColor.brightness() - this.contrast * vec2D.y);
            }
            tColor.desaturate(0.05f);
            colorList.add(tColor);
        }
        return colorList;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return "analogous contrast: " + this.contrast + " theta: " + MathUtils.degrees((float)this.theta);
    }
}

