/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import toxi.color.ColorGradient;
import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.math.InterpolateStrategy;
import toxi.math.ScaleMap;

public class ToneMap {
    public ScaleMap map;
    public ColorList colors;

    public ToneMap(float f, float f2, ColorGradient colorGradient) {
        this(f, f2, colorGradient.calcGradient());
    }

    public ToneMap(float f, float f2, ColorList colorList) {
        this.map = new ScaleMap((double)f, (double)f2, 0.0, (double)(colorList.size() - 1));
        this.colors = colorList;
    }

    public ToneMap(float f, float f2, ReadonlyTColor readonlyTColor, ReadonlyTColor readonlyTColor2) {
        this(f, f2, new ColorList(readonlyTColor, readonlyTColor2));
    }

    public ToneMap(float f, float f2, ReadonlyTColor readonlyTColor, ReadonlyTColor readonlyTColor2, int n) {
        ColorGradient colorGradient = new ColorGradient();
        colorGradient.addColorAt(0.0f, readonlyTColor);
        colorGradient.addColorAt(n - 1, readonlyTColor2);
        this.colors = colorGradient.calcGradient(0.0f, n);
        this.map = new ScaleMap((double)f, (double)f2, 0.0, (double)(this.colors.size() - 1));
    }

    public int getARGBToneFor(float f) {
        return this.getToneFor(f).toARGB();
    }

    public ReadonlyTColor getToneFor(float f) {
        int n = this.colors.size() > 2 ? (int)(this.map.getClippedValueFor((double)f) + 0.5) : ((double)f >= this.map.getInputMedian() ? 1 : 0);
        return this.colors.get(n);
    }

    public void setMapFunction(InterpolateStrategy interpolateStrategy) {
        this.map.setMapFunction(interpolateStrategy);
    }
}

