/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import toxi.math.MathUtils;

public class Hue {
    protected static final HashMap<String, Hue> namedHues = new HashMap();
    protected static final ArrayList<Hue> primaryHues = new ArrayList();
    public static final Hue RED = new Hue("red", 0.0f, true);
    public static final Hue ORANGE = new Hue("orange", 0.083333336f, true);
    public static final Hue YELLOW = new Hue("yellow", 0.16666667f, true);
    public static final Hue LIME = new Hue("lime", 0.25f);
    public static final Hue GREEN = new Hue("green", 0.33333334f, true);
    public static final Hue TEAL = new Hue("teal", 0.41666666f);
    public static final Hue CYAN = new Hue("cyan", 0.5f);
    public static final Hue AZURE = new Hue("azure", 0.5833333f);
    public static final Hue BLUE = new Hue("blue", 0.6666667f, true);
    public static final Hue INDIGO = new Hue("indigo", 0.75f);
    public static final Hue PURPLE = new Hue("purple", 0.8333333f, true);
    public static final Hue PINK = new Hue("pink", 0.9166667f, true);
    public static float PRIMARY_VARIANCE = 0.01f;
    protected String name;
    protected float hue;
    protected boolean isPrimary;

    public static final Hue getClosest(float f, boolean bl) {
        f %= 1.0f;
        float f2 = Float.MAX_VALUE;
        Hue hue = null;
        Collection<Hue> collection = bl ? primaryHues : namedHues.values();
        for (Hue hue2 : collection) {
            float f3 = MathUtils.min((float)MathUtils.abs((float)(hue2.hue - f)), (float)MathUtils.abs((float)(1.0f + hue2.hue - f)));
            if (!(f3 < f2)) continue;
            f2 = f3;
            hue = hue2;
        }
        return hue;
    }

    public static final Hue getForName(String string) {
        return namedHues.get(string.toLowerCase());
    }

    public static boolean isPrimary(float f) {
        return Hue.isPrimary(f, PRIMARY_VARIANCE);
    }

    public static boolean isPrimary(float f, float f2) {
        boolean bl = false;
        for (Hue hue : primaryHues) {
            if (!(MathUtils.abs((float)(f - hue.hue)) < f2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Hue(String string, float f) {
        this(string, f, false);
    }

    public Hue(String string, float f, boolean bl) {
        this.name = string;
        this.hue = f;
        this.isPrimary = bl;
        namedHues.put(string, this);
        if (bl) {
            primaryHues.add(this);
        }
    }

    public float getHue() {
        return this.hue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public String toString() {
        return "Hue: ID:" + this.name + " @ " + (int)(this.hue * 360.0f) + " degrees";
    }
}

