/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import toxi.color.ColorList;
import toxi.color.HistEntry;
import toxi.color.TColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram
implements Iterable<HistEntry> {
    protected ColorList palette;
    protected ArrayList<HistEntry> entries;

    public static Histogram newFromARGBArray(int[] nArray, int n, float f, boolean bl) {
        Histogram histogram = new Histogram(ColorList.createFromARGBArray(nArray, n, false));
        histogram.compute(f, bl);
        return histogram;
    }

    public Histogram(ColorList colorList) {
        this.palette = colorList;
    }

    List<HistEntry> compute(float f, boolean bl) {
        this.entries = new ArrayList(this.palette.size() / 4);
        float f2 = 1.0f;
        for (TColor object : this.palette) {
            HistEntry histEntry = null;
            for (HistEntry histEntry2 : this.entries) {
                if (!(histEntry2.col.distanceToRGB(object) < f)) continue;
                if (bl) {
                    histEntry2.col.blend(object, 1.0f / (histEntry2.freq + 1.0f));
                }
                histEntry = histEntry2;
                break;
            }
            if (histEntry != null) {
                histEntry.freq += 1.0f;
                if (!(histEntry.freq > f2)) continue;
                f2 = histEntry.freq;
                continue;
            }
            this.entries.add(new HistEntry(object));
        }
        Collections.sort(this.entries);
        f2 = 1.0f / (float)this.palette.size();
        for (HistEntry histEntry : this.entries) {
            histEntry.freq *= f2;
        }
        return this.entries;
    }

    public List<HistEntry> getEntries() {
        return this.entries;
    }

    public ColorList getPalette() {
        return this.palette;
    }

    @Override
    public Iterator<HistEntry> iterator() {
        return this.entries.iterator();
    }

    public void setPalette(ColorList colorList) {
        this.palette = colorList;
    }
}

