/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import toxi.color.AccessCriteria;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;

public class HSVAccessor
extends AccessCriteria {
    private final int component;

    public HSVAccessor(int n) {
        this.component = n;
    }

    public int compare(ReadonlyTColor readonlyTColor, ReadonlyTColor readonlyTColor2) {
        float f;
        float f2;
        switch (this.component) {
            case 0: {
                f2 = readonlyTColor.hue();
                f = readonlyTColor2.hue();
                break;
            }
            case 1: {
                f2 = readonlyTColor.saturation();
                f = readonlyTColor2.saturation();
                break;
            }
            default: {
                f2 = readonlyTColor.brightness();
                f = readonlyTColor2.brightness();
            }
        }
        return Float.compare(f2, f);
    }

    public float getComponentValueFor(ReadonlyTColor readonlyTColor) {
        float f;
        switch (this.component) {
            case 0: {
                f = readonlyTColor.hue();
                break;
            }
            case 1: {
                f = readonlyTColor.saturation();
                break;
            }
            default: {
                f = readonlyTColor.brightness();
            }
        }
        return f;
    }

    public void setComponentValueFor(TColor tColor, float f) {
        switch (this.component) {
            case 0: {
                tColor.setHue(f);
                break;
            }
            case 1: {
                tColor.setSaturation(f);
                break;
            }
            default: {
                tColor.setBrightness(f);
            }
        }
    }
}

