/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import toxi.color.ColorList;
import toxi.color.Hue;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.math.MathUtils;
import toxi.util.datatypes.FloatRange;
import toxi.util.datatypes.GenericSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorRange {
    public static final float DEFAULT_VARIANCE = 0.035f;
    public static final ColorRange LIGHT = new ColorRange(null, new FloatRange(0.3f, 0.7f), new FloatRange(0.9f, 1.0f), null, new FloatRange(0.15f, 0.3f), null, "light");
    public static final ColorRange DARK = new ColorRange(null, new FloatRange(0.7f, 1.0f), new FloatRange(0.15f, 0.4f), null, null, new FloatRange(0.5f, 0.75f), "dark");
    public static final ColorRange BRIGHT = new ColorRange(null, new FloatRange(0.8f, 1.0f), new FloatRange(0.8f, 1.0f), "bright");
    public static final ColorRange WEAK = new ColorRange(null, new FloatRange(0.15f, 0.3f), new FloatRange(0.7f, 1.0f), null, new FloatRange(0.2f, 0.2f), null, "weak");
    public static final ColorRange NEUTRAL = new ColorRange(null, new FloatRange(0.25f, 0.35f), new FloatRange(0.3f, 0.7f), null, new FloatRange(0.15f, 0.15f), new FloatRange(0.9f, 1.0f), "neutral");
    public static final ColorRange FRESH = new ColorRange(null, new FloatRange(0.4f, 0.8f), new FloatRange(0.8f, 1.0f), null, new FloatRange(0.05f, 0.3f), new FloatRange(0.8f, 1.0f), "fresh");
    public static final ColorRange SOFT = new ColorRange(null, new FloatRange(0.2f, 0.3f), new FloatRange(0.6f, 0.9f), null, new FloatRange(0.05f, 0.15f), new FloatRange(0.6f, 0.9f), "soft");
    public static final ColorRange HARD = new ColorRange(null, new FloatRange(0.9f, 1.0f), new FloatRange(0.4f, 1.0f), "hard");
    public static final ColorRange WARM = new ColorRange(null, new FloatRange(0.6f, 0.9f), new FloatRange(0.4f, 0.9f), null, new FloatRange(0.2f, 0.2f), new FloatRange(0.8f, 1.0f), "warm");
    public static final ColorRange COOL = new ColorRange(null, new FloatRange(0.05f, 0.2f), new FloatRange(0.9f, 1.0f), null, null, new FloatRange(0.95f, 1.0f), "cool");
    public static final ColorRange INTENSE = new ColorRange(null, new FloatRange(0.9f, 1.0f), new FloatRange(0.2f, 0.35f), "intense").addBrightnessRange(new FloatRange(0.8f, 1.0f));
    public static final HashMap<String, ColorRange> PRESETS = new HashMap();
    private static int UNTITLED_ID = 1;
    protected GenericSet<FloatRange> hueConstraint;
    protected GenericSet<FloatRange> saturationConstraint;
    protected GenericSet<FloatRange> brightnessConstraint;
    protected GenericSet<FloatRange> alphaConstraint;
    protected FloatRange white;
    protected FloatRange black;
    protected String name;

    public static ColorRange getPresetForName(String string) {
        return PRESETS.get(string.toUpperCase());
    }

    private ColorRange() {
    }

    public ColorRange(ColorList colorList) {
        this(colorList.get(0));
        this.hueConstraint.clear();
        for (TColor tColor : colorList) {
            this.add(tColor);
        }
    }

    public ColorRange(FloatRange floatRange, FloatRange floatRange2, FloatRange floatRange3, FloatRange floatRange4, FloatRange floatRange5, FloatRange floatRange6, String string) {
        this.hueConstraint = new GenericSet((Object[])new FloatRange[]{floatRange != null ? floatRange : new FloatRange(0.0f, 1.0f)});
        this.saturationConstraint = new GenericSet((Object[])new FloatRange[]{floatRange2 != null ? floatRange2 : new FloatRange(0.0f, 1.0f)});
        this.brightnessConstraint = new GenericSet((Object[])new FloatRange[]{floatRange3 != null ? floatRange3 : new FloatRange(0.0f, 1.0f)});
        this.alphaConstraint = new GenericSet((Object[])new FloatRange[]{floatRange4 != null ? floatRange4 : new FloatRange(1.0f, 1.0f)});
        this.black = floatRange5 == null ? new FloatRange(0.0f, 0.0f) : floatRange5;
        this.white = floatRange6 == null ? new FloatRange(1.0f, 1.0f) : floatRange6;
        this.name = string != null ? string : "untitled" + UNTITLED_ID++;
    }

    public ColorRange(FloatRange floatRange, FloatRange floatRange2, FloatRange floatRange3, FloatRange floatRange4, String string) {
        this(floatRange, floatRange2, floatRange3, floatRange4, null, null, string);
    }

    public ColorRange(FloatRange floatRange, FloatRange floatRange2, FloatRange floatRange3, String string) {
        this(floatRange, floatRange2, floatRange3, null, null, null, string);
    }

    public ColorRange(Hue hue) {
        this(new FloatRange(hue.getHue(), hue.getHue()), null, null, null, null, null, null);
    }

    public ColorRange(ReadonlyTColor readonlyTColor) {
        this(new FloatRange(readonlyTColor.hue(), readonlyTColor.hue()), null, null, null, null, null, null);
    }

    public ColorRange add(ColorRange colorRange) {
        this.hueConstraint.addAll((Collection)colorRange.hueConstraint.getItems());
        this.saturationConstraint.addAll((Collection)colorRange.saturationConstraint.getItems());
        this.brightnessConstraint.addAll((Collection)colorRange.brightnessConstraint.getItems());
        this.alphaConstraint.addAll((Collection)colorRange.alphaConstraint.getItems());
        this.black.min = MathUtils.min((float)this.black.min, (float)colorRange.black.min);
        this.black.max = MathUtils.max((float)this.black.max, (float)colorRange.black.max);
        this.white.min = MathUtils.min((float)this.white.min, (float)colorRange.white.min);
        this.white.max = MathUtils.max((float)this.white.max, (float)colorRange.white.max);
        return this;
    }

    public ColorRange add(ReadonlyTColor readonlyTColor) {
        this.hueConstraint.add((Object)new FloatRange(readonlyTColor.hue(), readonlyTColor.hue()));
        this.saturationConstraint.add((Object)new FloatRange(readonlyTColor.saturation(), readonlyTColor.saturation()));
        this.brightnessConstraint.add((Object)new FloatRange(readonlyTColor.brightness(), readonlyTColor.brightness()));
        this.alphaConstraint.add((Object)new FloatRange(readonlyTColor.alpha(), readonlyTColor.alpha()));
        return this;
    }

    public ColorRange addAlphaRange(float f, float f2) {
        return this.addAlphaRange(new FloatRange(f, f2));
    }

    public ColorRange addAlphaRange(FloatRange floatRange) {
        this.alphaConstraint.add((Object)floatRange);
        return this;
    }

    public ColorRange addBrightnessRange(float f, float f2) {
        return this.addBrightnessRange(new FloatRange(f, f2));
    }

    public ColorRange addBrightnessRange(FloatRange floatRange) {
        this.brightnessConstraint.add((Object)floatRange);
        return this;
    }

    public ColorRange addHue(Hue hue) {
        this.hueConstraint.add((Object)new FloatRange(hue.getHue(), hue.getHue()));
        return this;
    }

    public ColorRange addHueRange(float f, float f2) {
        if (f2 >= f) {
            this.addHueRange(new FloatRange(f, f2));
        } else {
            this.addHueRange(new FloatRange(f, 1.0f));
            this.addHueRange(new FloatRange(0.0f, f2));
        }
        return this;
    }

    public ColorRange addHueRange(FloatRange floatRange) {
        this.hueConstraint.add((Object)floatRange);
        return this;
    }

    public ColorRange addSaturationRange(float f, float f2) {
        return this.addAlphaRange(new FloatRange(f, f2));
    }

    public ColorRange addSaturationRange(FloatRange floatRange) {
        this.saturationConstraint.add((Object)floatRange);
        return this;
    }

    public boolean contains(ReadonlyTColor readonlyTColor) {
        boolean bl = this.isValueInConstraint(readonlyTColor.hue(), this.hueConstraint);
        bl &= this.isValueInConstraint(readonlyTColor.saturation(), this.saturationConstraint);
        bl &= this.isValueInConstraint(readonlyTColor.brightness(), this.brightnessConstraint);
        return bl &= this.isValueInConstraint(readonlyTColor.alpha(), this.alphaConstraint);
    }

    public ColorRange copy() {
        return this.copy(null, 0.0f);
    }

    public ColorRange copy(ReadonlyTColor readonlyTColor, float f) {
        ColorRange colorRange = new ColorRange();
        colorRange.name = this.name;
        if (readonlyTColor != null) {
            float f2 = readonlyTColor.hue() + f * MathUtils.normalizedRandom();
            colorRange.hueConstraint = new GenericSet((Object[])new FloatRange[]{new FloatRange(f2, f2)});
            colorRange.alphaConstraint = new GenericSet((Object[])new FloatRange[]{new FloatRange(readonlyTColor.alpha(), readonlyTColor.alpha())});
        } else {
            colorRange.hueConstraint = this.hueConstraint.copy();
            colorRange.alphaConstraint = this.alphaConstraint.copy();
        }
        colorRange.saturationConstraint = this.saturationConstraint.copy();
        colorRange.brightnessConstraint = this.brightnessConstraint.copy();
        colorRange.black = this.black.copy();
        colorRange.white = this.white.copy();
        return colorRange;
    }

    public TColor getColor() {
        return this.getColor(null, 0.0f);
    }

    public TColor getColor(Hue hue) {
        return TColor.newHSVA(hue.getHue(), ((FloatRange)this.saturationConstraint.pickRandom()).pickRandom(), ((FloatRange)this.brightnessConstraint.pickRandom()).pickRandom(), ((FloatRange)this.alphaConstraint.pickRandom()).pickRandom());
    }

    public TColor getColor(ReadonlyTColor readonlyTColor, float f) {
        float f2;
        float f3;
        if (readonlyTColor != null) {
            if (readonlyTColor.isBlack()) {
                return TColor.newHSVA(readonlyTColor.hue(), 0.0f, this.black.pickRandom(), readonlyTColor.alpha());
            }
            if (readonlyTColor.isWhite()) {
                return TColor.newHSVA(readonlyTColor.hue(), 0.0f, this.white.pickRandom(), readonlyTColor.alpha());
            }
            if (readonlyTColor.isGrey()) {
                return TColor.newHSVA(readonlyTColor.hue(), 0.0f, MathUtils.flipCoin() ? this.black.pickRandom() : this.white.pickRandom(), readonlyTColor.alpha());
            }
            f3 = readonlyTColor.hue() + f * MathUtils.normalizedRandom();
            f2 = readonlyTColor.alpha();
        } else {
            f3 = ((FloatRange)this.hueConstraint.pickRandom()).pickRandom();
            f2 = ((FloatRange)this.alphaConstraint.pickRandom()).pickRandom();
        }
        float f4 = ((FloatRange)this.saturationConstraint.pickRandom()).pickRandom();
        float f5 = ((FloatRange)this.brightnessConstraint.pickRandom()).pickRandom();
        return TColor.newHSVA(f3, f4, f5, f2);
    }

    public ColorList getColors(int n) {
        return this.getColors(null, n, 0.035f);
    }

    public ColorList getColors(ReadonlyTColor readonlyTColor, int n, float f) {
        ColorList colorList = new ColorList();
        for (int i = 0; i < n; ++i) {
            colorList.add(this.getColor(readonlyTColor, f));
        }
        return colorList;
    }

    public TColor getGrayscale(float f, float f2) {
        return this.getColor(TColor.newGray(f), f2);
    }

    public String getName() {
        return this.name;
    }

    public ColorRange getSum(ColorRange colorRange) {
        return this.copy().add(colorRange);
    }

    protected boolean isValueInConstraint(float f, GenericSet<FloatRange> genericSet) {
        boolean bl = false;
        for (FloatRange floatRange : genericSet) {
            bl |= floatRange.isValueInRange(f);
        }
        return bl;
    }

    static {
        Field[] fieldArray = ColorRange.class.getDeclaredFields();
        try {
            for (Field field : fieldArray) {
                if (field.getType() != ColorRange.class) continue;
                String string = field.getName();
                PRESETS.put(string, (ColorRange)field.get(null));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }
}

