/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import toxi.color.AccessCriteria;
import toxi.color.DistanceProxy;
import toxi.color.HSVDistanceProxy;
import toxi.color.ProximityComparator;
import toxi.color.RGBDistanceProxy;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryRegistry;
import toxi.color.theory.ColorTheoryStrategy;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorList
implements Iterable<TColor> {
    protected List<TColor> colors = new ArrayList<TColor>();

    public static final ColorList createFromARGBArray(int[] nArray, int n, boolean bl) {
        return ColorList.createFromARGBArray(nArray, n, bl, 100);
    }

    public static final ColorList createFromARGBArray(int[] nArray, int n, boolean bl, int n2) {
        n = MathUtils.min((int)n, (int)nArray.length);
        ArrayList<TColor> arrayList = new ArrayList<TColor>();
        TColor tColor = TColor.BLACK.copy();
        for (int i = 0; i < n; ++i) {
            int n3;
            if (bl) {
                boolean bl2 = true;
                int n4 = 0;
                do {
                    n3 = MathUtils.random((int)nArray.length);
                    tColor.setARGB(nArray[n3]);
                    boolean bl3 = bl2 = !arrayList.contains(tColor);
                } while (!bl2 && ++n4 < n2);
                if (n4 >= 100) break;
                arrayList.add(tColor.copy());
                continue;
            }
            n3 = MathUtils.random((int)nArray.length);
            arrayList.add(TColor.newARGB(nArray[n3]));
        }
        return new ColorList(arrayList);
    }

    public static final ColorList createUsingStrategy(ColorTheoryStrategy colorTheoryStrategy, TColor tColor) {
        return colorTheoryStrategy.createListFromColor(tColor);
    }

    public static final ColorList createUsingStrategy(String string, TColor tColor) {
        ColorTheoryStrategy colorTheoryStrategy = ColorTheoryRegistry.getStrategyForName(string);
        ColorList colorList = null;
        if (colorTheoryStrategy != null) {
            colorList = colorTheoryStrategy.createListFromColor(tColor);
        }
        return colorList;
    }

    public ColorList() {
    }

    public ColorList(Collection<TColor> collection) {
        this.colors.addAll(collection);
    }

    public ColorList(ColorList colorList) {
        for (TColor tColor : colorList) {
            this.colors.add(tColor.copy());
        }
    }

    public ColorList(int[] nArray) {
        for (int n : nArray) {
            this.colors.add(TColor.newARGB(n));
        }
    }

    public ColorList(ReadonlyTColor ... readonlyTColorArray) {
        for (ReadonlyTColor readonlyTColor : readonlyTColorArray) {
            this.colors.add(readonlyTColor.copy());
        }
    }

    public ColorList add(ReadonlyTColor readonlyTColor) {
        this.colors.add(readonlyTColor.copy());
        return this;
    }

    public ColorList addAll(Collection<TColor> collection) {
        this.colors.addAll(collection);
        return this;
    }

    public ColorList adjustBrightness(float f) {
        for (TColor tColor : this.colors) {
            tColor.lighten(f);
        }
        return this;
    }

    public ColorList adjustSaturation(float f) {
        for (TColor tColor : this.colors) {
            tColor.saturate(f);
        }
        return this;
    }

    public ColorList clusterSort(AccessCriteria accessCriteria, AccessCriteria accessCriteria2, int n, boolean bl) {
        ArrayList<TColor> arrayList = new ArrayList<TColor>(this.colors);
        Collections.sort(arrayList, accessCriteria);
        Collections.reverse(arrayList);
        ArrayList<TColor> arrayList2 = new ArrayList<TColor>();
        float f = 1.0f;
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            ReadonlyTColor readonlyTColor = arrayList.get(i);
            if (!(readonlyTColor.getComponentValue(accessCriteria) < f)) continue;
            ArrayList<TColor> arrayList3 = new ArrayList<TColor>();
            arrayList3.addAll(arrayList.subList(n2, i));
            Collections.sort(arrayList3, accessCriteria2);
            arrayList2.addAll(arrayList3);
            f -= 1.0f / (float)n;
            n2 = i;
        }
        ArrayList<TColor> arrayList4 = new ArrayList<TColor>();
        arrayList4.addAll(arrayList.subList(n2, arrayList.size()));
        Collections.sort(arrayList4, accessCriteria2);
        arrayList2.addAll(arrayList4);
        if (bl) {
            Collections.reverse(arrayList2);
        }
        this.colors = arrayList2;
        return this;
    }

    public ColorList complement() {
        for (TColor tColor : this.colors) {
            tColor.complement();
        }
        return this;
    }

    public boolean contains(ReadonlyTColor readonlyTColor) {
        for (TColor tColor : this.colors) {
            if (!((Object)tColor).equals(readonlyTColor)) continue;
            return true;
        }
        return false;
    }

    public TColor get(int n) {
        return this.colors.get(n);
    }

    public ReadonlyTColor getAverage() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (TColor tColor : this.colors) {
            f += tColor.rgb[0];
            f2 += tColor.rgb[1];
            f3 += tColor.rgb[2];
            f4 += tColor.alpha;
        }
        int n = this.colors.size();
        if (n > 0) {
            return TColor.newRGBA(f / (float)n, f2 / (float)n, f3 / (float)n, f4 / (float)n);
        }
        return null;
    }

    public ColorList getBlended(float f) {
        ReadonlyTColor[] readonlyTColorArray = new TColor[this.colors.size()];
        for (int i = 0; i < readonlyTColorArray.length; ++i) {
            TColor tColor = this.colors.get(i > 0 ? i - 1 : readonlyTColorArray.length - 1);
            readonlyTColorArray[i] = this.colors.get(i).getBlended(tColor, f);
        }
        return new ColorList(readonlyTColorArray);
    }

    public TColor getDarkest() {
        TColor tColor = null;
        float f = Float.MAX_VALUE;
        for (TColor tColor2 : this.colors) {
            float f2 = tColor2.luminance();
            if (!(f2 < f)) continue;
            tColor = tColor2;
            f = f2;
        }
        return tColor;
    }

    public ReadonlyTColor getLightest() {
        TColor tColor = null;
        float f = Float.MIN_VALUE;
        for (TColor tColor2 : this.colors) {
            float f2 = tColor2.luminance();
            if (!(f2 > f)) continue;
            tColor = tColor2;
            f = f2;
        }
        return tColor;
    }

    public TColor getRandom() {
        return this.colors.get(MathUtils.random((int)this.colors.size()));
    }

    public ColorList getReverse() {
        return new ColorList(this.colors).reverse();
    }

    public ColorList invert() {
        for (TColor tColor : this.colors) {
            tColor.invert();
        }
        return this;
    }

    @Override
    public Iterator<TColor> iterator() {
        return this.colors.iterator();
    }

    public ColorList reverse() {
        Collections.reverse(this.colors);
        return this;
    }

    public ColorList rotateRYB(float f) {
        return this.rotateRYB(MathUtils.degrees((float)f));
    }

    public ColorList rotateRYB(int n) {
        for (TColor tColor : this.colors) {
            tColor.rotateRYB(n);
        }
        return this;
    }

    public int size() {
        return this.colors.size();
    }

    public ColorList sort() {
        return this.sortByCriteria(AccessCriteria.HUE, false);
    }

    public ColorList sortByComparator(Comparator<ReadonlyTColor> comparator, boolean bl) {
        Collections.sort(this.colors, comparator);
        if (bl) {
            Collections.reverse(this.colors);
        }
        return this;
    }

    public ColorList sortByCriteria(AccessCriteria accessCriteria, boolean bl) {
        return this.sortByComparator(accessCriteria, bl);
    }

    public ColorList sortByDistance(boolean bl) {
        return this.sortByDistance(new HSVDistanceProxy(), bl);
    }

    public ColorList sortByDistance(DistanceProxy distanceProxy, boolean bl) {
        if (this.colors.size() == 0) {
            return this;
        }
        TColor tColor = this.getDarkest();
        ArrayList<TColor> arrayList = new ArrayList<TColor>(this.colors);
        arrayList.remove(tColor);
        ArrayList<TColor> arrayList2 = new ArrayList<TColor>(this.colors.size());
        arrayList2.add(tColor);
        int n = 0;
        while (arrayList.size() > 1) {
            TColor tColor2 = arrayList.get(0);
            TColor tColor3 = (TColor)arrayList2.get(n);
            float f = distanceProxy.distanceBetween(tColor2, tColor3);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                TColor tColor4 = arrayList.get(i);
                float f2 = distanceProxy.distanceBetween(tColor4, tColor3);
                if (!(f2 < f)) continue;
                tColor2 = tColor4;
                f = f2;
            }
            arrayList.remove(tColor2);
            arrayList2.add(tColor2);
            ++n;
        }
        arrayList2.add(arrayList.get(0));
        if (bl) {
            Collections.reverse(arrayList2);
        }
        this.colors = arrayList2;
        return this;
    }

    public ColorList sortByProximityTo(ReadonlyTColor readonlyTColor, boolean bl) {
        return this.sortByProximityTo(readonlyTColor, new RGBDistanceProxy(), bl);
    }

    public ColorList sortByProximityTo(ReadonlyTColor readonlyTColor, DistanceProxy distanceProxy, boolean bl) {
        return this.sortByComparator(new ProximityComparator(readonlyTColor, distanceProxy), bl);
    }

    public int[] toARGBArray() {
        int[] nArray = new int[this.colors.size()];
        int n = 0;
        for (TColor tColor : this.colors) {
            nArray[n++] = tColor.toARGB();
        }
        return nArray;
    }
}

