/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.math.InterpolateStrategy;
import toxi.math.LinearInterpolation;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorGradient {
    protected TreeSet<GradPoint> gradient;
    protected float maxDither;
    protected InterpolateStrategy interpolator = new LinearInterpolation();

    public ColorGradient() {
        this.gradient = new TreeSet();
    }

    public void addColorAt(float f, ReadonlyTColor readonlyTColor) {
        this.gradient.add(new GradPoint(f, readonlyTColor));
    }

    public ColorList calcGradient() {
        float f = this.gradient.first().getPosition();
        return this.calcGradient(f, (int)(this.gradient.last().getPosition() - f));
    }

    /*
     * WARNING - void declaration
     */
    public ColorList calcGradient(float f, int n) {
        float f2;
        void var9_14;
        ColorList colorList = new ColorList();
        if (this.gradient.size() == 0) {
            return colorList;
        }
        float f3 = 0.0f;
        GradPoint gradPoint = null;
        GradPoint gradPoint2 = null;
        float f4 = f + (float)n;
        for (GradPoint object2 : this.gradient) {
            if (!(object2.pos < f)) continue;
            gradPoint = object2;
        }
        boolean bl = gradPoint == null;
        Object var9_11 = null;
        if (!bl) {
            TreeSet treeSet = (TreeSet)this.gradient.tailSet(gradPoint);
        } else {
            TreeSet<GradPoint> treeSet = this.gradient;
            gradPoint = treeSet.first();
        }
        float f5 = 0.0f;
        Iterator iterator = var9_14.iterator();
        if (gradPoint != var9_14.last()) {
            gradPoint2 = (GradPoint)iterator.next();
            if (bl) {
                f2 = gradPoint.pos - f;
                f5 = MathUtils.abs((float)f2) > 0.0f ? 1.0f / f2 : 1.0f;
            } else if (gradPoint2.pos - gradPoint.pos > 0.0f) {
                f5 = 1.0f / (gradPoint2.pos - gradPoint.pos);
            }
        }
        while (f < f4) {
            f3 = bl ? 1.0f - (gradPoint.pos - f) * f5 : (f - gradPoint.pos) * f5;
            if ((double)f3 > 1.0) {
                gradPoint = gradPoint2;
                bl = false;
                if (iterator.hasNext()) {
                    gradPoint2 = (GradPoint)iterator.next();
                    f5 = gradPoint != var9_14.last() ? 1.0f / (gradPoint2.pos - gradPoint.pos) : 0.0f;
                    f3 = (f - gradPoint.pos) * f5;
                }
            }
            if (gradPoint != var9_14.last()) {
                f2 = MathUtils.clip((float)(f3 + MathUtils.normalizedRandom() * this.maxDither), (float)0.0f, (float)1.0f);
                f2 = this.interpolator.interpolate(0.0f, 1.0f, f2);
                colorList.add(gradPoint.color.getBlended(gradPoint2.color, f2));
            } else {
                colorList.add(gradPoint.color.copy());
            }
            f += 1.0f;
        }
        return colorList;
    }

    public List<GradPoint> getGradientPoints() {
        return new ArrayList<GradPoint>(this.gradient);
    }

    public InterpolateStrategy getInterpolator() {
        return this.interpolator;
    }

    public float getMaxDither() {
        return this.maxDither;
    }

    public void setInterpolator(InterpolateStrategy interpolateStrategy) {
        this.interpolator = interpolateStrategy;
    }

    public void setMaxDither(float f) {
        this.maxDither = MathUtils.clip((float)f, (float)0.0f, (float)1.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class GradPoint
    implements Comparable<GradPoint> {
        protected float pos;
        protected ReadonlyTColor color;

        GradPoint(float f, ReadonlyTColor readonlyTColor) {
            this.pos = f;
            this.color = readonlyTColor;
        }

        @Override
        public int compareTo(GradPoint gradPoint) {
            if (Float.compare(gradPoint.pos, this.pos) == 0) {
                return 0;
            }
            return this.pos < gradPoint.pos ? -1 : 1;
        }

        public ReadonlyTColor getColor() {
            return this.color;
        }

        public float getPosition() {
            return this.pos;
        }
    }
}

