/*
 * Decompiled with CFR 0.152.
 */
package toxi.color.theory;

import toxi.color.ColorList;
import toxi.color.ReadonlyTColor;
import toxi.color.TColor;
import toxi.color.theory.ColorTheoryStrategy;
import toxi.math.MathUtils;

public class MonochromeTheoryStrategy
implements ColorTheoryStrategy {
    public static final String NAME = "monochrome";

    private static final float wrap(float f, float f2, float f3, float f4) {
        if (f - f2 < f3) {
            return f + f4;
        }
        return f - f2;
    }

    public ColorList createListFromColor(ReadonlyTColor readonlyTColor) {
        ColorList colorList = new ColorList(readonlyTColor);
        TColor tColor = readonlyTColor.copy();
        tColor.setBrightness(MonochromeTheoryStrategy.wrap(tColor.brightness(), 0.5f, 0.2f, 0.3f));
        tColor.setSaturation(MonochromeTheoryStrategy.wrap(tColor.saturation(), 0.3f, 0.1f, 0.3f));
        colorList.add(tColor);
        tColor = readonlyTColor.copy();
        tColor.setBrightness(MonochromeTheoryStrategy.wrap(tColor.brightness(), 0.2f, 0.2f, 0.6f));
        colorList.add(tColor);
        tColor = readonlyTColor.copy();
        tColor.setBrightness(MathUtils.max((float)0.2f, (float)(tColor.brightness() + (1.0f - tColor.brightness()) * 0.2f)));
        tColor.setSaturation(MonochromeTheoryStrategy.wrap(tColor.saturation(), 0.3f, 0.1f, 0.3f));
        colorList.add(tColor);
        tColor = readonlyTColor.copy();
        tColor.setBrightness(MonochromeTheoryStrategy.wrap(tColor.brightness(), 0.5f, 0.2f, 0.3f));
        colorList.add(tColor);
        return colorList;
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return NAME;
    }
}

