/*
 * Decompiled with CFR 0.152.
 */
package toxi.color;

import toxi.color.AccessCriteria;
import toxi.color.Hue;
import toxi.color.ReadonlyTColor;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

public class TColor
implements ReadonlyTColor {
    protected static final float INV60DEGREES = 0.16666667f;
    protected static final float INV8BIT = 0.003921569f;
    protected static final double EPS = 0.001;
    protected static final Vec2D[] RYB_WHEEL = new Vec2D[]{new Vec2D(0.0f, 0.0f), new Vec2D(15.0f, 8.0f), new Vec2D(30.0f, 17.0f), new Vec2D(45.0f, 26.0f), new Vec2D(60.0f, 34.0f), new Vec2D(75.0f, 41.0f), new Vec2D(90.0f, 48.0f), new Vec2D(105.0f, 54.0f), new Vec2D(120.0f, 60.0f), new Vec2D(135.0f, 81.0f), new Vec2D(150.0f, 103.0f), new Vec2D(165.0f, 123.0f), new Vec2D(180.0f, 138.0f), new Vec2D(195.0f, 155.0f), new Vec2D(210.0f, 171.0f), new Vec2D(225.0f, 187.0f), new Vec2D(240.0f, 204.0f), new Vec2D(255.0f, 219.0f), new Vec2D(270.0f, 234.0f), new Vec2D(285.0f, 251.0f), new Vec2D(300.0f, 267.0f), new Vec2D(315.0f, 282.0f), new Vec2D(330.0f, 298.0f), new Vec2D(345.0f, 329.0f), new Vec2D(360.0f, 0.0f)};
    public static float BLACK_POINT = 0.08f;
    public static float WHITE_POINT = 1.0f;
    public static float GREY_THRESHOLD = 0.01f;
    public static final ReadonlyTColor RED = TColor.newRGB(1.0f, 0.0f, 0.0f);
    public static final ReadonlyTColor GREEN = TColor.newRGB(0.0f, 1.0f, 0.0f);
    public static final ReadonlyTColor BLUE = TColor.newRGB(0.0f, 0.0f, 1.0f);
    public static final ReadonlyTColor CYAN = TColor.newRGB(0.0f, 1.0f, 1.0f);
    public static final ReadonlyTColor MAGENTA = TColor.newRGB(1.0f, 0.0f, 1.0f);
    public static final ReadonlyTColor YELLOW = TColor.newRGB(1.0f, 1.0f, 0.0f);
    public static final ReadonlyTColor BLACK = TColor.newRGB(0.0f, 0.0f, 0.0f);
    public static final ReadonlyTColor WHITE = TColor.newRGB(1.0f, 1.0f, 1.0f);
    protected float[] rgb = new float[3];
    protected float[] cmyk;
    protected float[] hsv = new float[3];
    public float alpha;

    public static final float[] cmykToRGB(float f, float f2, float f3, float f4) {
        return TColor.cmykToRGB(f, f2, f3, f4, new float[3]);
    }

    public static final float[] cmykToRGB(float f, float f2, float f3, float f4, float[] fArray) {
        fArray[0] = 1.0f - MathUtils.min((float)1.0f, (float)(f + f4));
        fArray[1] = 1.0f - MathUtils.min((float)1.0f, (float)(f2 + f4));
        fArray[2] = 1.0f - MathUtils.min((float)1.0f, (float)(f3 + f4));
        return fArray;
    }

    public static final float[] hexToRGB(String string) {
        return TColor.hexToRGB(string, new float[3]);
    }

    public static final float[] hexToRGB(String string, float[] fArray) {
        try {
            int n = Integer.parseInt(string, 16);
            fArray[0] = (float)(n >> 16 & 0xFF) * 0.003921569f;
            fArray[1] = (float)(n >> 8 & 0xFF) * 0.003921569f;
            fArray[2] = (float)(n & 0xFF) * 0.003921569f;
        }
        catch (NumberFormatException numberFormatException) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
        }
        return fArray;
    }

    public static final float[] hsvToRGB(float f, float f2, float f3) {
        return TColor.hsvToRGB(f, f2, f3, new float[3]);
    }

    public static final float[] hsvToRGB(float f, float f2, float f3, float[] fArray) {
        if (Float.compare(f2, 0.0f) == 0) {
            fArray[1] = fArray[2] = f3;
            fArray[0] = fArray[2];
        } else {
            int n = (int)(f /= 0.16666667f);
            float f4 = f - (float)n;
            float f5 = f3 * (1.0f - f2);
            float f6 = f3 * (1.0f - f2 * f4);
            float f7 = f3 * (1.0f - f2 * (1.0f - f4));
            if (n == 0) {
                fArray[0] = f3;
                fArray[1] = f7;
                fArray[2] = f5;
            } else if (n == 1) {
                fArray[0] = f6;
                fArray[1] = f3;
                fArray[2] = f5;
            } else if (n == 2) {
                fArray[0] = f5;
                fArray[1] = f3;
                fArray[2] = f7;
            } else if (n == 3) {
                fArray[0] = f5;
                fArray[1] = f6;
                fArray[2] = f3;
            } else if (n == 4) {
                fArray[0] = f7;
                fArray[1] = f5;
                fArray[2] = f3;
            } else {
                fArray[0] = f3;
                fArray[1] = f5;
                fArray[2] = f6;
            }
        }
        return fArray;
    }

    public static final float[] labToRGB(float f, float f2, float f3) {
        return TColor.labToRGB(f, f2, f3, new float[3]);
    }

    public static final float[] labToRGB(float f, float f2, float f3, float[] fArray) {
        float f4 = (f + 16.0f) / 116.0f;
        float f5 = f2 / 500.0f + f4;
        float f6 = f4 - f3 / 200.0f;
        fArray[0] = f5;
        fArray[1] = f4;
        fArray[2] = f6;
        for (int i = 0; i < 3; ++i) {
            float f7 = (float)Math.pow(fArray[i], 3.0);
            fArray[i] = (double)f7 > 0.008856 ? f7 : (fArray[i] - 0.13793103f) / 7.787f;
        }
        f5 = fArray[0] * 0.95047f;
        f4 = fArray[1];
        f6 = fArray[2] * 1.08883f;
        fArray[0] = f5 * 3.2406f + f4 * -1.5372f + f6 * -0.4986f;
        fArray[1] = f5 * -0.9689f + f4 * 1.8758f + f6 * 0.0415f;
        fArray[2] = f5 * 0.0557f + f4 * -0.204f + f6 * 1.057f;
        double d = 0.4166666666666667;
        for (int i = 0; i < 3; ++i) {
            fArray[i] = (double)fArray[i] > 0.0031308 ? (float)(1.055 * Math.pow(fArray[i], d) - 0.055) : 12.92f * fArray[i];
        }
        return fArray;
    }

    public static final TColor newARGB(int n) {
        return TColor.newRGBA((float)(n >> 16 & 0xFF) * 0.003921569f, (float)(n >> 8 & 0xFF) * 0.003921569f, (float)(n & 0xFF) * 0.003921569f, (float)(n >>> 24) * 0.003921569f);
    }

    public static final TColor newCMYK(float f, float f2, float f3, float f4) {
        return TColor.newCMYKA(f, f2, f3, f4, 1.0f);
    }

    public static final TColor newCMYKA(float f, float f2, float f3, float f4, float f5) {
        TColor tColor = new TColor();
        tColor.setCMYK(new float[]{f, f2, f3, f4});
        tColor.alpha = MathUtils.clip((float)f5, (float)0.0f, (float)1.0f);
        return tColor;
    }

    public static final TColor newGray(float f) {
        return TColor.newGrayAlpha(f, 1.0f);
    }

    public static final TColor newGrayAlpha(float f, float f2) {
        TColor tColor = new TColor();
        tColor.setRGB(new float[]{f, f, f});
        tColor.alpha = f2;
        return tColor;
    }

    public static final TColor newHex(String string) {
        TColor tColor = new TColor();
        tColor.setRGB(TColor.hexToRGB(string));
        tColor.alpha = 1.0f;
        return tColor;
    }

    public static final TColor newHSV(float f, float f2, float f3) {
        return TColor.newHSVA(f, f2, f3, 1.0f);
    }

    public static ReadonlyTColor newHSV(Hue hue, float f, float f2) {
        return TColor.newHSV(hue.getHue(), f, f2);
    }

    public static final TColor newHSVA(float f, float f2, float f3, float f4) {
        TColor tColor = new TColor();
        tColor.setHSV(f, f2, f3);
        tColor.alpha = MathUtils.clip((float)f4, (float)0.0f, (float)1.0f);
        return tColor;
    }

    public static final TColor newRandom() {
        return TColor.newRGBA(MathUtils.random((float)1.0f), MathUtils.random((float)1.0f), MathUtils.random((float)1.0f), 1.0f);
    }

    public static final TColor newRGB(float f, float f2, float f3) {
        return TColor.newRGBA(f, f2, f3, 1.0f);
    }

    public static final TColor newRGBA(float f, float f2, float f3, float f4) {
        TColor tColor = new TColor();
        tColor.setRGB(new float[]{f, f2, f3});
        tColor.alpha = MathUtils.clip((float)f4, (float)0.0f, (float)1.0f);
        return tColor;
    }

    public static final float[] rgbToCMYK(float f, float f2, float f3) {
        return TColor.rgbToCMYK(f, f2, f3, new float[4]);
    }

    public static final float[] rgbToCMYK(float f, float f2, float f3, float[] fArray) {
        fArray[0] = 1.0f - f;
        fArray[1] = 1.0f - f2;
        fArray[2] = 1.0f - f3;
        fArray[3] = MathUtils.min((float)fArray[0], (float)fArray[1], (float)fArray[2]);
        fArray[0] = MathUtils.clip((float)(fArray[0] - fArray[3]), (float)0.0f, (float)1.0f);
        fArray[1] = MathUtils.clip((float)(fArray[1] - fArray[3]), (float)0.0f, (float)1.0f);
        fArray[2] = MathUtils.clip((float)(fArray[2] - fArray[3]), (float)0.0f, (float)1.0f);
        fArray[3] = MathUtils.clip((float)fArray[3], (float)0.0f, (float)1.0f);
        return fArray;
    }

    public static final String rgbToHex(float f, float f2, float f3) {
        String string = Integer.toHexString((int)(MathUtils.clip((float)f, (float)0.0f, (float)1.0f) * 255.0f)) + Integer.toHexString((int)(MathUtils.clip((float)f2, (float)0.0f, (float)1.0f) * 255.0f)) + Integer.toHexString((int)(MathUtils.clip((float)f3, (float)0.0f, (float)1.0f) * 255.0f));
        return string;
    }

    public static final float[] rgbToHSV(float f, float f2, float f3) {
        return TColor.rgbToHSV(f, f2, f3, new float[3]);
    }

    public static final float[] rgbToHSV(float f, float f2, float f3, float[] fArray) {
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = MathUtils.max((float)f, (float)f2, (float)f3);
        float f7 = f6 - MathUtils.min((float)f, (float)f2, (float)f3);
        if ((double)f6 != 0.0) {
            f5 = f7 / f6;
        }
        if ((double)f5 != 0.0) {
            f4 = Float.compare(f, f6) == 0 ? (f2 - f3) / f7 : (Float.compare(f2, f6) == 0 ? 2.0f + (f3 - f) / f7 : 4.0f + (f - f2) / f7);
        }
        if ((f4 *= 0.16666667f) < 0.0f) {
            f4 += 1.0f;
        }
        fArray[0] = f4;
        fArray[1] = f5;
        fArray[2] = f6;
        return fArray;
    }

    protected TColor() {
        this.cmyk = new float[4];
    }

    public TColor(ReadonlyTColor readonlyTColor) {
        this();
        float[] fArray = readonlyTColor.toCMYKAArray(null);
        System.arraycopy(fArray, 0, this.cmyk, 0, 4);
        System.arraycopy(readonlyTColor.toHSVAArray(fArray), 0, this.hsv, 0, 3);
        System.arraycopy(readonlyTColor.toRGBAArray(fArray), 0, this.rgb, 0, 3);
        this.alpha = readonlyTColor.alpha();
    }

    public TColor add(TColor tColor) {
        return this.copy().addSelf(tColor);
    }

    public TColor addSelf(TColor tColor) {
        this.rgb[0] = MathUtils.min((float)(this.rgb[0] + tColor.rgb[0]), (float)1.0f);
        this.rgb[1] = MathUtils.min((float)(this.rgb[1] + tColor.rgb[1]), (float)1.0f);
        this.rgb[2] = MathUtils.min((float)(this.rgb[2] + tColor.rgb[2]), (float)1.0f);
        return this.setRGB(this.rgb);
    }

    public ReadonlyTColor adjustConstrast(float f) {
        return (double)this.hsv[2] < 0.5 ? this.darken(f) : this.lighten(f);
    }

    public ReadonlyTColor adjustHSV(float f, float f2, float f3) {
        return this.setHSV(new float[]{this.hsv[0] + f, this.hsv[1] + f2, this.hsv[2] + f3});
    }

    public ReadonlyTColor adjustRGB(float f, float f2, float f3) {
        return this.setRGB(new float[]{this.rgb[0] + f, this.rgb[1] + f2, this.rgb[2] + f3});
    }

    public float alpha() {
        return this.alpha;
    }

    public TColor analog(float f, float f2) {
        return this.analog((int)MathUtils.degrees((float)f), f2);
    }

    public TColor analog(int n, float f) {
        this.rotateRYB((int)((float)n * MathUtils.normalizedRandom()));
        this.hsv[1] = this.hsv[1] + f * MathUtils.normalizedRandom();
        this.hsv[2] = this.hsv[2] + f * MathUtils.normalizedRandom();
        return this.setHSV(this.hsv);
    }

    public float black() {
        return this.cmyk[0];
    }

    public TColor blend(ReadonlyTColor readonlyTColor, float f) {
        float[] fArray = readonlyTColor.toRGBAArray(null);
        this.rgb[0] = this.rgb[0] + (fArray[0] - this.rgb[0]) * f;
        this.rgb[1] = this.rgb[1] + (fArray[1] - this.rgb[1]) * f;
        this.rgb[2] = this.rgb[2] + (fArray[2] - this.rgb[2]) * f;
        this.alpha += (readonlyTColor.alpha() - this.alpha) * f;
        return this.setRGB(this.rgb);
    }

    public float blue() {
        return this.rgb[2];
    }

    public float brightness() {
        return this.hsv[2];
    }

    public TColor complement() {
        return this.rotateRYB(180);
    }

    public TColor copy() {
        return new TColor(this);
    }

    public float cyan() {
        return this.cmyk[0];
    }

    public TColor darken(float f) {
        this.hsv[2] = MathUtils.clip((float)(this.hsv[2] - f), (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public TColor desaturate(float f) {
        this.hsv[1] = MathUtils.clip((float)(this.hsv[1] - f), (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public TColor differenceTo(TColor tColor) {
        return TColor.newRGB(MathUtils.abs((float)(this.rgb[0] - tColor.rgb[0])), MathUtils.abs((float)(this.rgb[1] - tColor.rgb[1])), MathUtils.abs((float)(this.rgb[2] - tColor.rgb[2])));
    }

    public float distanceToCMYK(ReadonlyTColor readonlyTColor) {
        float[] fArray = readonlyTColor.toCMYKAArray(null);
        float f = this.cmyk[0] - fArray[0];
        float f2 = this.cmyk[1] - fArray[1];
        float f3 = this.cmyk[2] - fArray[2];
        float f4 = this.cmyk[3] - fArray[3];
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
    }

    public float distanceToHSV(ReadonlyTColor readonlyTColor) {
        float f = this.hsv[0] * ((float)Math.PI * 2);
        float f2 = readonlyTColor.hue() * ((float)Math.PI * 2);
        Vec3D vec3D = new Vec3D(MathUtils.cos((float)f) * this.hsv[1], MathUtils.sin((float)f) * this.hsv[1], this.hsv[2]);
        Vec3D vec3D2 = new Vec3D(MathUtils.cos((float)f2) * readonlyTColor.saturation(), MathUtils.sin((float)f2) * readonlyTColor.saturation(), readonlyTColor.brightness());
        return vec3D.distanceTo((ReadonlyVec3D)vec3D2);
    }

    public float distanceToRGB(ReadonlyTColor readonlyTColor) {
        float[] fArray = readonlyTColor.toRGBAArray(null);
        float f = this.rgb[0] - fArray[0];
        float f2 = this.rgb[1] - fArray[1];
        float f3 = this.rgb[2] - fArray[2];
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TColor) {
            TColor tColor = (TColor)object;
            float f = tColor.rgb[0] - this.rgb[0];
            float f2 = tColor.rgb[1] - this.rgb[1];
            float f3 = tColor.rgb[2] - this.rgb[2];
            float f4 = tColor.alpha - this.alpha;
            double d = Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
            return d < 0.001;
        }
        return false;
    }

    public TColor getAnalog(float f, float f2) {
        return new TColor(this).analog(f, f2);
    }

    public TColor getAnalog(int n, float f) {
        return new TColor(this).analog(n, f);
    }

    public TColor getBlended(ReadonlyTColor readonlyTColor, float f) {
        return new TColor(this).blend(readonlyTColor, f);
    }

    public Hue getClosestHue() {
        return Hue.getClosest(this.hsv[0], false);
    }

    public Hue getClosestHue(boolean bl) {
        return Hue.getClosest(this.hsv[0], bl);
    }

    public TColor getComplement() {
        return new TColor(this).complement();
    }

    public float getComponentValue(AccessCriteria accessCriteria) {
        return accessCriteria.getComponentValueFor(this);
    }

    public TColor getDarkened(float f) {
        return new TColor(this).darken(f);
    }

    public TColor getDesaturated(float f) {
        return new TColor(this).desaturate(f);
    }

    public TColor getDifferenceTo(TColor tColor) {
        return this.copy().differenceTo(tColor);
    }

    public TColor getInverted() {
        return new TColor(this).invert();
    }

    public TColor getLightened(float f) {
        return new TColor(this).lighten(f);
    }

    public TColor getRotatedRYB(float f) {
        return new TColor(this).rotateRYB(f);
    }

    public TColor getRotatedRYB(int n) {
        return new TColor(this).rotateRYB(n);
    }

    public TColor getSaturated(float f) {
        return new TColor(this).saturate(f);
    }

    public float green() {
        return this.rgb[1];
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.rgb[0]);
        n += 37 * n + Float.floatToIntBits(this.rgb[1]);
        n += 37 * n + Float.floatToIntBits(this.rgb[2]);
        n += 37 * n + Float.floatToIntBits(this.alpha);
        return n;
    }

    public float hue() {
        return this.hsv[0];
    }

    public TColor invert() {
        this.rgb[0] = 1.0f - this.rgb[0];
        this.rgb[1] = 1.0f - this.rgb[1];
        this.rgb[2] = 1.0f - this.rgb[2];
        return this.setRGB(this.rgb);
    }

    public boolean isBlack() {
        return this.rgb[0] <= BLACK_POINT && Float.compare(this.rgb[0], this.rgb[1]) == 0 && Float.compare(this.rgb[0], this.rgb[2]) == 0;
    }

    public boolean isGrey() {
        return this.hsv[1] < GREY_THRESHOLD;
    }

    public boolean isPrimary() {
        return Hue.isPrimary(this.hsv[0]);
    }

    public boolean isWhite() {
        return this.rgb[0] >= WHITE_POINT && Float.compare(this.rgb[0], this.rgb[1]) == 0 && Float.compare(this.rgb[0], this.rgb[2]) == 0;
    }

    public TColor lighten(float f) {
        this.hsv[2] = MathUtils.clip((float)(this.hsv[2] + f), (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public float luminance() {
        return this.rgb[0] * 0.299f + this.rgb[1] * 0.587f + this.rgb[2] * 0.114f;
    }

    public float magenta() {
        return this.cmyk[0];
    }

    public float red() {
        return this.rgb[0];
    }

    public TColor rotateRYB(float f) {
        return this.rotateRYB((int)MathUtils.degrees((float)f));
    }

    public TColor rotateRYB(int n) {
        Vec2D vec2D;
        Vec2D vec2D2;
        int n2;
        float f = this.hsv[0] * 360.0f;
        n %= 360;
        float f2 = 0.0f;
        for (n2 = 0; n2 < RYB_WHEEL.length - 1; ++n2) {
            vec2D2 = RYB_WHEEL[n2];
            vec2D = RYB_WHEEL[n2 + 1];
            if (vec2D.y < vec2D2.y) {
                vec2D.y += 360.0f;
            }
            if (!(vec2D2.y <= f) || !(f <= vec2D.y)) continue;
            f2 = vec2D2.x + (vec2D.x - vec2D2.x) * (f - vec2D2.y) / (vec2D.y - vec2D2.y);
            break;
        }
        f2 = (f2 + (float)n) % 360.0f;
        for (n2 = 0; n2 < RYB_WHEEL.length - 1; ++n2) {
            vec2D2 = RYB_WHEEL[n2];
            vec2D = RYB_WHEEL[n2 + 1];
            if (vec2D.y < vec2D2.y) {
                vec2D.y += 360.0f;
            }
            if (!(vec2D2.x <= f2) || !(f2 <= vec2D.x)) continue;
            f = vec2D2.y + (vec2D.y - vec2D2.y) * (f2 - vec2D2.x) / (vec2D.x - vec2D2.x);
            break;
        }
        this.hsv[0] = f % 360.0f / 360.0f;
        return this.setHSV(this.hsv);
    }

    public TColor saturate(float f) {
        this.hsv[1] = MathUtils.clip((float)(this.hsv[1] + f), (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public float saturation() {
        return this.hsv[1];
    }

    public TColor setAlpha(float f) {
        this.alpha = f;
        return this;
    }

    public TColor setARGB(int n) {
        this.setRGB((float)(n >> 16 & 0xFF) * 0.003921569f, (float)(n >> 8 & 0xFF) * 0.003921569f, (float)(n & 0xFF) * 0.003921569f);
        this.alpha = (float)(n >>> 24) * 0.003921569f;
        return this;
    }

    public TColor setBlack(float f) {
        this.cmyk[3] = f;
        return this.setCMYK(this.cmyk);
    }

    public TColor setBlue(float f) {
        this.rgb[2] = f;
        return this.setRGB(this.rgb);
    }

    public TColor setBrightness(float f) {
        this.hsv[2] = MathUtils.clip((float)f, (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public TColor setCMYK(float f, float f2, float f3, float f4) {
        this.cmyk[0] = f;
        this.cmyk[1] = f2;
        this.cmyk[2] = f3;
        this.cmyk[3] = f4;
        return this.setCMYK(this.cmyk);
    }

    public TColor setCMYK(float[] fArray) {
        this.cmyk[0] = MathUtils.clip((float)fArray[0], (float)0.0f, (float)1.0f);
        this.cmyk[1] = MathUtils.clip((float)fArray[1], (float)0.0f, (float)1.0f);
        this.cmyk[2] = MathUtils.clip((float)fArray[2], (float)0.0f, (float)1.0f);
        this.cmyk[3] = MathUtils.clip((float)fArray[3], (float)0.0f, (float)1.0f);
        TColor.cmykToRGB(this.cmyk[0], this.cmyk[1], this.cmyk[2], this.cmyk[3], this.rgb);
        TColor.rgbToHSV(this.rgb[0], this.rgb[1], this.rgb[2], this.hsv);
        return this;
    }

    public TColor setComponent(AccessCriteria accessCriteria, float f) {
        accessCriteria.setComponentValueFor(this, f);
        return this;
    }

    public TColor setCyan(float f) {
        this.cmyk[0] = f;
        return this.setCMYK(this.cmyk);
    }

    public TColor setGreen(float f) {
        this.rgb[1] = f;
        return this.setRGB(this.rgb);
    }

    public TColor setHSV(float f, float f2, float f3) {
        this.hsv[0] = f;
        this.hsv[1] = f2;
        this.hsv[2] = f3;
        return this.setHSV(this.hsv);
    }

    public TColor setHSV(float[] fArray) {
        this.hsv[0] = fArray[0] % 1.0f;
        if (this.hsv[0] < 0.0f) {
            this.hsv[0] = this.hsv[0] + 1.0f;
        }
        this.hsv[1] = MathUtils.clip((float)fArray[1], (float)0.0f, (float)1.0f);
        this.hsv[2] = MathUtils.clip((float)fArray[2], (float)0.0f, (float)1.0f);
        TColor.hsvToRGB(this.hsv[0], this.hsv[1], this.hsv[2], this.rgb);
        TColor.rgbToCMYK(this.rgb[0], this.rgb[1], this.rgb[2], this.cmyk);
        return this;
    }

    public void setHue(float f) {
        if ((double)(f = (float)((double)f % 1.0)) < 0.0) {
            f += 1.0f;
        }
        this.hsv[0] = f;
        this.setHSV(this.hsv);
    }

    public TColor setMagenta(float f) {
        this.cmyk[1] = f;
        return this.setCMYK(this.cmyk);
    }

    public TColor setRed(float f) {
        this.rgb[0] = f;
        return this.setRGB(this.rgb);
    }

    public TColor setRGB(float f, float f2, float f3) {
        this.rgb[0] = f;
        this.rgb[1] = f2;
        this.rgb[2] = f3;
        return this.setRGB(this.rgb);
    }

    public TColor setRGB(float[] fArray) {
        this.rgb[0] = MathUtils.clip((float)fArray[0], (float)0.0f, (float)1.0f);
        this.rgb[1] = MathUtils.clip((float)fArray[1], (float)0.0f, (float)1.0f);
        this.rgb[2] = MathUtils.clip((float)fArray[2], (float)0.0f, (float)1.0f);
        TColor.rgbToCMYK(this.rgb[0], this.rgb[1], this.rgb[2], this.cmyk);
        TColor.rgbToHSV(this.rgb[0], this.rgb[1], this.rgb[2], this.hsv);
        return this;
    }

    public TColor setSaturation(float f) {
        this.hsv[1] = MathUtils.clip((float)f, (float)0.0f, (float)1.0f);
        return this.setHSV(this.hsv);
    }

    public TColor setYellow(float f) {
        this.cmyk[2] = f;
        return this.setCMYK(this.cmyk);
    }

    public TColor sub(TColor tColor) {
        return this.copy().subSelf(tColor);
    }

    public TColor subSelf(TColor tColor) {
        this.rgb[0] = MathUtils.max((float)(this.rgb[0] - tColor.rgb[0]), (float)0.0f);
        this.rgb[1] = MathUtils.max((float)(this.rgb[1] - tColor.rgb[1]), (float)0.0f);
        this.rgb[2] = MathUtils.max((float)(this.rgb[2] - tColor.rgb[2]), (float)0.0f);
        return this.setRGB(this.rgb);
    }

    public int toARGB() {
        return (int)(this.rgb[0] * 255.0f) << 16 | (int)(this.rgb[1] * 255.0f) << 8 | (int)(this.rgb[2] * 255.0f) | (int)(this.alpha * 255.0f) << 24;
    }

    public float[] toCMYKAArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.cmyk[0], this.cmyk[1], this.cmyk[2], this.alpha};
        }
        return fArray;
    }

    public String toHex() {
        String string = Integer.toHexString(this.toARGB());
        if (string.length() > 6) {
            string = string.substring(2);
        }
        return string;
    }

    public float[] toHSVAArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.hsv[0], this.hsv[1], this.hsv[2], this.alpha};
        }
        return fArray;
    }

    public float[] toRGBAArray(float[] fArray) {
        return this.toRGBAArray(fArray, 0);
    }

    public float[] toRGBAArray(float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[4];
            n = 0;
        }
        fArray[n++] = this.rgb[0];
        fArray[n++] = this.rgb[1];
        fArray[n++] = this.rgb[2];
        fArray[n] = this.alpha;
        return fArray;
    }

    public String toString() {
        return "TColor: rgb: " + this.rgb[0] + "," + this.rgb[1] + "," + this.rgb[2] + " hsv: " + this.hsv[0] + "," + this.hsv[1] + "," + this.hsv[2] + " cmyk: " + this.cmyk[0] + "," + this.cmyk[1] + "," + this.cmyk[2] + "," + this.cmyk[3] + " alpha: " + this.alpha;
    }

    public float yellow() {
        return this.cmyk[0];
    }
}

