/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.fluids;

public class FluidSolver {
    protected int numIterations = 10;
    protected int width;
    protected int totalWidth;
    protected int height;
    protected int totalHeight;
    protected int size;
    protected float timeStep;
    protected float viscosity = 0.0f;
    protected float diffusion = 1.0E-6f;
    protected float buoyancyA = 6.25E-4f;
    protected float buoyancyB = 0.025f;
    protected float[] tmp;
    protected float[] d;
    protected float[] dOld;
    protected float[] u;
    protected float[] uOld;
    protected float[] v;
    protected float[] vOld;
    protected float[] curl;

    public FluidSolver(int n, int n2, float f) {
        this.width = n;
        this.height = n2;
        this.totalWidth = n + 2;
        this.totalHeight = n2 + 2;
        this.timeStep = f;
        this.size = this.totalWidth * this.totalHeight;
        this.d = new float[this.size];
        this.dOld = new float[this.size];
        this.u = new float[this.size];
        this.uOld = new float[this.size];
        this.v = new float[this.size];
        this.vOld = new float[this.size];
        this.curl = new float[this.size];
        this.reset();
    }

    protected void addSource(float[] fArray, float[] fArray2) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            fArray[n] = fArray[n] + this.timeStep * fArray2[i];
        }
    }

    protected void advect(int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = (float)this.width + 0.5f;
        float f2 = (float)this.height + 0.5f;
        float f3 = this.timeStep * (float)this.width;
        int n2 = 1;
        int n3 = 1;
        int n4 = n2 + this.totalWidth;
        while (n3 <= this.height) {
            float f4 = (float)n2 - f3 * fArray3[n4];
            float f5 = (float)n3 - f3 * fArray4[n4];
            if (f4 > f) {
                f4 = f;
            }
            if (f4 < 0.5f) {
                f4 = 0.5f;
            }
            int n5 = (int)f4;
            if (f5 > f2) {
                f5 = f2;
            }
            if (f5 < 0.5f) {
                f5 = 0.5f;
            }
            int n6 = (int)f5;
            float f6 = f4 - (float)n5;
            float f7 = 1.0f - f6;
            float f8 = f5 - (float)n6;
            float f9 = 1.0f - f8;
            int n7 = n5 + n6 * this.totalWidth;
            fArray[n4] = f7 * (f9 * fArray2[n7] + f8 * fArray2[n7 + this.totalWidth]) + f6 * (f9 * fArray2[n7 + 1] + f8 * fArray2[n7 + this.totalWidth + 1]);
            if (n2 < this.width) {
                ++n2;
                ++n4;
                continue;
            }
            n2 = 1;
            ++n3;
            n4 += 3;
        }
        this.setBoundary(n, fArray);
    }

    protected void buoyancy(float[] fArray) {
        float f = 0.0f;
        int n = 1;
        int n2 = 1 + this.totalWidth;
        int n3 = 1;
        while (n3 <= this.height) {
            f += this.d[n2];
            if (n < this.width) {
                ++n;
                ++n2;
                continue;
            }
            n = 1;
            ++n3;
            n2 += 3;
        }
        f /= (float)(this.width * this.height);
        n = 1;
        n2 = 1 + this.totalWidth;
        n3 = 1;
        while (n3 <= this.height) {
            float f2 = this.d[n2];
            fArray[n2] = this.buoyancyA * f2 - this.buoyancyB * (f2 - f);
            if (n < this.width) {
                ++n;
                ++n2;
                continue;
            }
            n = 1;
            ++n3;
            n2 += 3;
        }
    }

    protected final float curl(int n) {
        float f = (this.u[n + this.totalWidth] - this.u[n - this.totalWidth]) * 0.5f;
        float f2 = (this.v[n + 1] - this.v[n - 1]) * 0.5f;
        return f - f2;
    }

    public final void decay(float f) {
        int n = 0;
        while (n < this.size) {
            int n2 = n;
            this.u[n2] = this.u[n2] * f;
            int n3 = n;
            this.v[n3] = this.v[n3] * f;
            int n4 = n++;
            this.d[n4] = this.d[n4] * f;
        }
    }

    public void densitySolver() {
        this.addSource(this.d, this.dOld);
        this.swap(this.d, this.dOld);
        this.diffusion(0, this.d, this.dOld, this.diffusion);
        this.swap(this.d, this.dOld);
        this.advect(0, this.d, this.dOld, this.u, this.v);
        for (int i = 0; i < this.size; ++i) {
            this.dOld[i] = 0.0f;
        }
    }

    protected void diffusion(int n, float[] fArray, float[] fArray2, float f) {
        float f2 = this.timeStep * f * (float)this.width * (float)this.height;
        this.linearSolver(n, fArray, fArray2, f2, 1.0f + 4.0f * f2);
    }

    protected void linearSolver(int n, float[] fArray, float[] fArray2, float f, float f2) {
        f2 = 1.0f / f2;
        for (int i = 0; i < this.numIterations; ++i) {
            int n2 = 1;
            int n3 = 1 + this.totalWidth;
            int n4 = 1;
            while (n4 <= this.height) {
                fArray[n3] = (f * (fArray[n3 - 1] + fArray[n3 + 1] + fArray[n3 - this.totalWidth] + fArray[n3 + this.totalWidth]) + fArray2[n3]) * f2;
                if (n2 < this.width) {
                    ++n2;
                    ++n3;
                    continue;
                }
                n2 = 1;
                n3 = ++n4 * this.totalWidth + 1;
            }
            this.setBoundary(n, fArray);
        }
    }

    protected void project(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = -0.5f / (float)this.width;
        int n = 1;
        int n2 = 1 + this.totalWidth;
        int n3 = 1;
        while (n3 <= this.height) {
            fArray4[n2] = (fArray[n2 + 1] - fArray[n2 - 1] + fArray2[n2 + this.totalWidth] - fArray2[n2 - this.totalWidth]) * f;
            fArray3[n2] = 0.0f;
            if (n < this.width) {
                ++n;
                ++n2;
                continue;
            }
            n = 1;
            ++n3;
            n2 += 3;
        }
        this.setBoundary(0, fArray4);
        this.setBoundary(0, fArray3);
        this.linearSolver(0, fArray3, fArray4, 1.0f, 4.0f);
        f = -0.5f * (float)this.width;
        n = 1;
        n2 = 1 + this.totalWidth;
        n3 = 1;
        while (n3 <= this.height) {
            int n4 = n2;
            fArray[n4] = fArray[n4] + f * (fArray3[n2 + 1] - fArray3[n2 - 1]);
            int n5 = n2;
            fArray2[n5] = fArray2[n5] + f * (fArray3[n2 + this.totalWidth] - fArray3[n2 - this.totalWidth]);
            if (n < this.width) {
                ++n;
                ++n2;
                continue;
            }
            n = 1;
            n2 += 3;
            ++n3;
        }
        this.setBoundary(1, fArray);
        this.setBoundary(2, fArray2);
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.vOld[i] = 0.0f;
            this.v[i] = 0.0f;
            this.uOld[i] = 0.0f;
            this.u[i] = 0.0f;
            this.curl[i] = 0.0f;
            this.dOld[i] = 0.0f;
            this.d[i] = 0.0f;
        }
    }

    protected void setBoundary(int n, float[] fArray) {
        int n2 = this.height * this.totalWidth;
        int n3 = this.totalWidth;
        for (int i = 1; i <= this.width; ++i) {
            fArray[n3] = n == 1 ? -fArray[n3 + 1] : fArray[n3 + 1];
            fArray[this.width + 1 + n3] = n == 1 ? -fArray[n3 + this.width] : fArray[n3 + this.width];
            fArray[i] = n == 2 ? -fArray[this.totalWidth + i] : fArray[this.totalWidth + i];
            fArray[i + n2 + this.totalWidth] = n == 2 ? -fArray[n2 + i] : fArray[n2 + i];
            n3 += this.totalWidth;
        }
        fArray[0] = 0.5f * (fArray[1] + fArray[this.totalWidth]);
        fArray[n2 + this.totalWidth] = 0.5f * (fArray[1 + this.totalWidth + n2] + fArray[n2]);
        fArray[this.width + 1] = 0.5f * (fArray[this.width] + fArray[this.width + 1 + this.totalWidth]);
        fArray[this.width + 1 + this.totalWidth + n2] = 0.5f * (fArray[this.width + this.totalWidth + n2] + fArray[this.width + 1 + n2]);
    }

    protected final void swap(float[] fArray, float[] fArray2) {
        this.tmp = fArray;
        fArray = fArray2;
        fArray2 = this.tmp;
    }

    public void velocitySolver() {
        this.addSource(this.u, this.uOld);
        this.addSource(this.v, this.vOld);
        this.vorticityConfinement(this.uOld, this.vOld);
        this.addSource(this.u, this.uOld);
        this.addSource(this.v, this.vOld);
        this.buoyancy(this.vOld);
        this.addSource(this.v, this.vOld);
        this.swap(this.u, this.uOld);
        this.diffusion(0, this.u, this.uOld, this.viscosity);
        this.swap(this.v, this.vOld);
        this.diffusion(0, this.v, this.vOld, this.viscosity);
        this.project(this.u, this.v, this.uOld, this.vOld);
        this.swap(this.u, this.uOld);
        this.swap(this.v, this.vOld);
        this.advect(1, this.u, this.uOld, this.uOld, this.vOld);
        this.advect(2, this.v, this.vOld, this.uOld, this.vOld);
        this.project(this.u, this.v, this.uOld, this.vOld);
        for (int i = 0; i < this.size; ++i) {
            this.vOld[i] = 0.0f;
            this.uOld[i] = 0.0f;
        }
    }

    public void vorticityConfinement(float[] fArray, float[] fArray2) {
        int n = 1;
        int n2 = 1;
        int n3 = n + this.totalWidth;
        while (n2 <= this.height) {
            float f = this.curl(n3);
            float f2 = this.curl[n3] = f > 0.0f ? f : -f;
            if (n < this.width) {
                ++n;
                ++n3;
                continue;
            }
            n = 1;
            ++n2;
            n3 += 3;
        }
        n = 2;
        n2 = 2;
        n3 = n + this.totalWidth * n2;
        while (n2 < this.height) {
            float f = (this.curl[n3 + 1] - this.curl[n3 - 1]) * 0.5f;
            float f3 = (this.curl[n3 + this.totalWidth] - this.curl[n3 - this.totalWidth]) * 0.5f;
            float f4 = 1.0f / ((float)Math.sqrt(f * f + f3 * f3) + 1.0E-6f);
            float f5 = this.curl[n3];
            fArray[n3] = (f3 *= f4) * -f5;
            fArray2[n3] = (f *= f4) * f5;
            if (n < this.width - 1) {
                ++n;
                ++n3;
                continue;
            }
            n = 2;
            ++n2;
            n3 += 5;
        }
    }
}

