/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.dla;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import toxi.geom.Line3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.sim.dla.DLASegment;
import toxi.sim.dla.PipelineOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLAGuideLines {
    protected static final Logger logger = Logger.getLogger(DLAGuideLines.class.getName());
    public SortedSet<DLASegment> segments;
    public Iterator<DLASegment> iterator;
    private double currT;
    private DLASegment currSegment;
    private Vec3D currPoint;
    private Vec3D workDir;

    public DLAGuideLines() {
        this(new PipelineOrder());
    }

    public DLAGuideLines(Comparator<Line3D> comparator) {
        this.segments = new TreeSet<Line3D>(comparator);
    }

    @Deprecated
    public DLAGuideLines addCurveStrip(List<Vec3D> list) {
        return this.addPointList(list);
    }

    public DLAGuideLines addLine(Line3D line3D) {
        return this.addLine(line3D.a, line3D.b);
    }

    public DLAGuideLines addLine(Vec3D vec3D, Vec3D vec3D2) {
        DLASegment dLASegment = new DLASegment(vec3D, vec3D2, null);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("adding line segment: " + (Object)((Object)dLASegment));
        }
        this.segments.add(dLASegment);
        return this;
    }

    public DLAGuideLines addPoint(Vec3D vec3D) {
        return this.addLine(vec3D, vec3D);
    }

    public DLAGuideLines addPointList(List<Vec3D> list) {
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            Vec3D vec3D = i < n - 1 ? list.get(i + 1) : null;
            DLASegment dLASegment = new DLASegment(list.get(i - 1), list.get(i), vec3D);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("adding line segment: " + (Object)((Object)dLASegment));
            }
            this.segments.add(dLASegment);
        }
        return this;
    }

    public double getCurrentSegmentPos() {
        return this.currT;
    }

    public Vec3D getDirection() {
        if (this.workDir == null) {
            this.getPoint();
        }
        return this.workDir;
    }

    public Vec3D getPoint() {
        this.workDir = this.currSegment.getDirection().interpolateToSelf((ReadonlyVec3D)this.currSegment.getNextDirection(), (float)this.currT);
        this.workDir.normalize();
        Vec3D vec3D = this.currPoint.add(this.workDir.scale(this.currSegment.getLength() * (float)this.currT));
        return vec3D;
    }

    public boolean isComplete() {
        return !this.iterator.hasNext() && this.currT >= 1.0;
    }

    public DLAGuideLines reset() {
        this.iterator = this.segments.iterator();
        this.currT = 0.0;
        this.currSegment = this.iterator.next();
        this.currPoint = this.currSegment.a.copy();
        return this;
    }

    public DLASegment updatePoint(double d) {
        this.currT += d;
        if (this.currT >= 1.0 && this.iterator.hasNext()) {
            this.currT -= 1.0;
            this.currSegment = this.iterator.next();
            this.currPoint = this.currSegment.a.copy();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("next segment: " + (Object)((Object)this.currSegment));
            }
        }
        return this.currSegment;
    }
}

