/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.automata;

import java.math.BigInteger;
import java.util.Random;
import toxi.math.MathUtils;
import toxi.sim.automata.CARule;
import toxi.sim.automata.EvolvableMatrix;

public class CAWolfram1D
implements CARule {
    protected boolean[] rules;
    protected int stateCount;
    protected boolean isTiling;
    protected int maxBitValue;
    protected int numBits;
    protected int kernelWidth;
    protected boolean isAutoexpire;

    public CAWolfram1D(int n, boolean bl) {
        this(n, 2, bl);
    }

    public CAWolfram1D(int n, int n2, boolean bl) {
        this.isTiling = bl;
        this.kernelWidth = n;
        this.stateCount = n2;
        this.maxBitValue = (int)Math.pow(4.0, n);
        this.numBits = this.maxBitValue * 2;
        this.rules = new boolean[this.numBits];
    }

    public void evolve(EvolvableMatrix evolvableMatrix) {
        int[] nArray = evolvableMatrix.getMatrix();
        int[] nArray2 = evolvableMatrix.getSwapBuffer();
        int n = this.stateCount - 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            int n3 = this.maxBitValue;
            for (int j = -this.kernelWidth; j <= this.kernelWidth; ++j) {
                int n4 = i + j;
                if (this.isTiling) {
                    if ((n4 %= nArray.length) < 0) {
                        n4 += nArray.length;
                    }
                    n2 += nArray[n4] > 0 ? n3 : 0;
                } else if (n4 >= 0 && n4 < nArray.length) {
                    n2 += nArray[n4] > 0 ? n3 : 0;
                }
                n3 >>>= 1;
            }
            nArray2[i] = this.isAutoexpire ? (this.rules[n2] ? (nArray[i] + 1) % this.stateCount : 0) : (this.rules[n2] ? MathUtils.min((int)(nArray[i] + 1), (int)n) : 0);
        }
    }

    public final int getNumRuleBits() {
        return this.numBits;
    }

    public final boolean[] getRuleArray() {
        return this.rules;
    }

    public final BigInteger getRuleAsBigInt() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = this.rules.length - 1; i >= 0; --i) {
            bigInteger = bigInteger.shiftLeft(1);
            if (!this.rules[i]) continue;
            bigInteger = bigInteger.setBit(0);
        }
        return bigInteger;
    }

    public int getStateCount() {
        return this.stateCount;
    }

    public boolean isAutoExpire() {
        return this.isAutoexpire;
    }

    public boolean isTiling() {
        return this.isTiling;
    }

    public void randomize() {
        this.setRuleID(new BigInteger(this.numBits, new Random()));
    }

    public void setAutoExpire(boolean bl) {
        this.isAutoexpire = bl;
    }

    public CAWolfram1D setRuleArray(boolean[] blArray) {
        if (blArray.length != this.numBits) {
            throw new IllegalArgumentException("rule array length needs to be equal to " + this.numBits + " for the given kernel size");
        }
        System.arraycopy(blArray, 0, this.rules, 0, blArray.length);
        return this;
    }

    public CAWolfram1D setRuleID(BigInteger bigInteger) {
        for (int i = 0; i < this.rules.length; ++i) {
            this.rules[i] = bigInteger.testBit(i);
        }
        return this;
    }

    public CAWolfram1D setRuleID(long l) {
        for (int i = 0; i < this.rules.length; ++i) {
            this.rules[i] = (l & 1L) == 1L;
            l >>>= 1;
        }
        return this;
    }

    public void setStateCount(int n) {
        this.stateCount = n;
    }

    public void setTiling(boolean bl) {
        this.isTiling = bl;
    }
}

