/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.automata;

import toxi.math.MathUtils;
import toxi.sim.automata.CARule;
import toxi.sim.automata.EvolvableMatrix;
import toxi.sim.automata.MatrixEvolver;

public class CAMatrix
implements EvolvableMatrix {
    protected int width;
    protected int height;
    protected int[] matrix;
    protected int[] swap;
    protected CARule rule;
    protected int generation;

    public CAMatrix(int n) {
        this(n, 1);
    }

    public CAMatrix(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.matrix = new int[n * n2];
        this.swap = new int[n * n2];
    }

    public CAMatrix addNoise(float f) {
        return this.addNoise(f, 0, this.rule != null ? this.rule.getStateCount() : 2);
    }

    public CAMatrix addNoise(float f, int n, int n2) {
        if (this.rule != null) {
            n = MathUtils.clip((int)n, (int)0, (int)this.rule.getStateCount());
            n2 = MathUtils.clip((int)n2, (int)0, (int)this.rule.getStateCount());
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    if (!(Math.random() < (double)f)) continue;
                    int n3 = j * this.width + i;
                    this.swap[n3] = this.matrix[n3] = MathUtils.random((int)n, (int)n2);
                }
            }
            return this;
        }
        throw new IllegalStateException("CA rule not yet initialized");
    }

    public CAMatrix drawBoxAt(int n, int n2, int n3, int n4) {
        for (int i = n2 - n3 / 2; i < n2 + n3 / 2; ++i) {
            for (int j = n - n3 / 2; j < n + n3 / 2; ++j) {
                if (j < 0 || j >= this.height || i < 0 || i >= this.width) continue;
                int n5 = j + i * this.width;
                this.swap[n5] = this.matrix[n5] = n4;
            }
        }
        return this;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getIndexFor(int n, int n2) {
        return n + n2 * this.width;
    }

    public final int[] getMatrix() {
        return this.matrix;
    }

    public final MatrixEvolver getRule() {
        return this.rule;
    }

    public final int[] getSwapBuffer() {
        return this.swap;
    }

    public final int getWidth() {
        return this.width;
    }

    public CAMatrix reset() {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = 0;
            this.swap[i] = 0;
        }
        this.generation = 0;
        return this;
    }

    public CAMatrix seedImage(int[] nArray, int n, int n2) {
        int n3 = MathUtils.clip((int)((this.width - n) / 2), (int)0, (int)(this.width - 1));
        int n4 = MathUtils.clip((int)((this.height - n2) / 2), (int)0, (int)(this.height - 1));
        n = MathUtils.min((int)n, (int)this.width);
        n2 = MathUtils.min((int)n2, (int)this.height);
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n;
            for (int j = 0; j < n; ++j) {
                if (0 >= (nArray[n5 + j] & 0xFF)) continue;
                int n6 = (n4 + i) * this.width + n3 + j;
                this.matrix[n6] = 1;
            }
        }
        return this;
    }

    public CAMatrix setRule(CARule cARule) {
        this.rule = cARule;
        return this;
    }

    public CAMatrix setStateAt(int n, int n2, int n3) {
        int n4 = n + n2 * this.width;
        if (n4 < 0 || n4 >= this.matrix.length) {
            throw new ArrayIndexOutOfBoundsException("given coordinates: " + n + ";" + n2 + " are out of bounds");
        }
        this.swap[n4] = this.matrix[n4] = n3;
        return this;
    }

    public CAMatrix update() {
        if (this.rule != null) {
            this.rule.evolve(this);
            System.arraycopy(this.swap, 0, this.matrix, 0, this.matrix.length);
            ++this.generation;
        }
        return this;
    }
}

