/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d;

import toxi.geom.Vec2D;
import toxi.physics2d.VerletParticle2D;

public class VerletSpring2D {
    protected static final float EPS = 1.0E-6f;
    public VerletParticle2D a;
    public VerletParticle2D b;
    protected float restLength;
    protected float restLengthSquared;
    protected float strength;
    protected boolean isALocked;
    protected boolean isBLocked;

    public VerletSpring2D(VerletParticle2D verletParticle2D, VerletParticle2D verletParticle2D2, float f, float f2) {
        this.a = verletParticle2D;
        this.b = verletParticle2D2;
        this.restLength = f;
        this.strength = f2;
    }

    public float getRestLength() {
        return this.restLength;
    }

    public float getStrength() {
        return this.strength;
    }

    public VerletSpring2D lockA(boolean bl) {
        this.isALocked = bl;
        return this;
    }

    public VerletSpring2D lockB(boolean bl) {
        this.isBLocked = bl;
        return this;
    }

    public VerletSpring2D setRestLength(float f) {
        this.restLength = f;
        this.restLengthSquared = f * f;
        return this;
    }

    public VerletSpring2D setStrength(float f) {
        this.strength = f;
        return this;
    }

    protected void update(boolean bl) {
        Vec2D vec2D = this.b.sub(this.a);
        float f = vec2D.magnitude() + 1.0E-6f;
        float f2 = (f - this.restLength) / (f * (this.a.invWeight + this.b.invWeight)) * this.strength;
        if (!this.a.isLocked && !this.isALocked) {
            this.a.addSelf(vec2D.scale(f2 * this.a.invWeight));
            if (bl) {
                this.a.applyConstraints();
            }
        }
        if (!this.b.isLocked && !this.isBLocked) {
            this.b.addSelf(vec2D.scale(-f2 * this.b.invWeight));
            if (bl) {
                this.b.applyConstraints();
            }
        }
    }
}

