/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;
import toxi.physics2d.VerletParticle2D;
import toxi.physics2d.VerletPhysics2D;
import toxi.physics2d.VerletSpring2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleString2D {
    protected VerletPhysics2D physics;
    public List<VerletParticle2D> particles;
    public List<VerletSpring2D> links;

    public ParticleString2D(VerletPhysics2D verletPhysics2D, List<VerletParticle2D> list, float f) {
        this.physics = verletPhysics2D;
        this.particles = new ArrayList<VerletParticle2D>(list);
        this.links = new ArrayList<VerletSpring2D>(this.particles.size() - 1);
        VerletParticle2D verletParticle2D = null;
        for (VerletParticle2D verletParticle2D2 : this.particles) {
            verletPhysics2D.addParticle(verletParticle2D2);
            if (verletParticle2D != null) {
                VerletSpring2D verletSpring2D = this.createSpring(verletParticle2D, verletParticle2D2, verletParticle2D.distanceTo((ReadonlyVec2D)verletParticle2D2), f);
                this.links.add(verletSpring2D);
                verletPhysics2D.addSpring(verletSpring2D);
            }
            verletParticle2D = verletParticle2D2;
        }
    }

    public ParticleString2D(VerletPhysics2D verletPhysics2D, Vec2D vec2D, Vec2D vec2D2, int n, float f, float f2) {
        this.physics = verletPhysics2D;
        this.particles = new ArrayList<VerletParticle2D>(n);
        this.links = new ArrayList<VerletSpring2D>(n - 1);
        float f3 = vec2D2.magnitude();
        VerletParticle2D verletParticle2D = null;
        vec2D = vec2D.copy();
        for (int i = 0; i < n; ++i) {
            VerletParticle2D verletParticle2D2 = new VerletParticle2D((ReadonlyVec2D)vec2D.copy(), f);
            this.particles.add(verletParticle2D2);
            verletPhysics2D.particles.add(verletParticle2D2);
            if (verletParticle2D != null) {
                VerletSpring2D verletSpring2D = this.createSpring(verletParticle2D, verletParticle2D2, f3, f2);
                this.links.add(verletSpring2D);
                verletPhysics2D.addSpring(verletSpring2D);
            }
            verletParticle2D = verletParticle2D2;
            vec2D.addSelf(vec2D2);
        }
    }

    public void clear() {
        for (VerletSpring2D verletSpring2D : this.links) {
            this.physics.removeSpringElements(verletSpring2D);
        }
        this.particles.clear();
        this.links.clear();
    }

    protected VerletSpring2D createSpring(VerletParticle2D verletParticle2D, VerletParticle2D verletParticle2D2, float f, float f2) {
        return new VerletSpring2D(verletParticle2D, verletParticle2D2, f, f2);
    }

    public VerletParticle2D getHead() {
        return this.particles.get(0);
    }

    public int getNumParticles() {
        return this.particles.size();
    }

    public VerletParticle2D getTail() {
        return this.particles.get(this.particles.size() - 1);
    }
}

