/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics.constraints;

import toxi.geom.AxisAlignedCylinder;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.constraints.ParticleConstraint;

public class CylinderConstraint
implements ParticleConstraint {
    protected AxisAlignedCylinder cylinder;
    protected Vec3D centroid = new Vec3D();
    protected Vec3D.Axis axis;

    public CylinderConstraint(AxisAlignedCylinder axisAlignedCylinder) {
        this.setCylinder(axisAlignedCylinder);
    }

    public void apply(VerletParticle verletParticle) {
        if (this.cylinder.containsPoint((ReadonlyVec3D)verletParticle)) {
            this.centroid.setComponent(this.axis, verletParticle.getComponent(this.axis));
            verletParticle.set(this.centroid.add(verletParticle.sub(this.centroid).normalizeTo(this.cylinder.getRadius())));
        }
    }

    public AxisAlignedCylinder getCylinder() {
        return this.cylinder;
    }

    public void setCylinder(AxisAlignedCylinder axisAlignedCylinder) {
        this.cylinder = axisAlignedCylinder;
        this.centroid.set(axisAlignedCylinder.getPosition());
        this.axis = axisAlignedCylinder.getMajorAxis();
    }
}

