/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.VerletPhysics;
import toxi.physics.VerletSpring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleString {
    protected VerletPhysics physics;
    public List<VerletParticle> particles;
    public List<VerletSpring> links;

    public ParticleString(VerletPhysics verletPhysics, List<VerletParticle> list, float f) {
        this.physics = verletPhysics;
        this.particles = new ArrayList<VerletParticle>(list);
        this.links = new ArrayList<VerletSpring>(this.particles.size() - 1);
        VerletParticle verletParticle = null;
        for (VerletParticle verletParticle2 : this.particles) {
            verletPhysics.addParticle(verletParticle2);
            if (verletParticle != null) {
                VerletSpring verletSpring = this.createSpring(verletParticle, verletParticle2, verletParticle.distanceTo((ReadonlyVec3D)verletParticle2), f);
                this.links.add(verletSpring);
                verletPhysics.addSpring(verletSpring);
            }
            verletParticle = verletParticle2;
        }
    }

    public ParticleString(VerletPhysics verletPhysics, Vec3D vec3D, Vec3D vec3D2, int n, float f, float f2) {
        this.physics = verletPhysics;
        this.particles = new ArrayList<VerletParticle>(n);
        this.links = new ArrayList<VerletSpring>(n - 1);
        float f3 = vec3D2.magnitude();
        VerletParticle verletParticle = null;
        vec3D = vec3D.copy();
        for (int i = 0; i < n; ++i) {
            VerletParticle verletParticle2 = new VerletParticle((ReadonlyVec3D)vec3D.copy(), f);
            this.particles.add(verletParticle2);
            verletPhysics.particles.add(verletParticle2);
            if (verletParticle != null) {
                VerletSpring verletSpring = this.createSpring(verletParticle, verletParticle2, f3, f2);
                this.links.add(verletSpring);
                verletPhysics.addSpring(verletSpring);
            }
            verletParticle = verletParticle2;
            vec3D.addSelf(vec3D2);
        }
    }

    public void clear() {
        for (VerletSpring verletSpring : this.links) {
            this.physics.removeSpringElements(verletSpring);
        }
        this.particles.clear();
        this.links.clear();
    }

    protected VerletSpring createSpring(VerletParticle verletParticle, VerletParticle verletParticle2, float f, float f2) {
        return new VerletSpring(verletParticle, verletParticle2, f, f2);
    }

    public VerletParticle getHead() {
        return this.particles.get(0);
    }

    public int getNumParticles() {
        return this.particles.size();
    }

    public VerletParticle getTail() {
        return this.particles.get(this.particles.size() - 1);
    }
}

