/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import toxi.util.datatypes.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndirectedGraph<N> {
    protected Map<N, Set<N>> nodeLinks = new HashMap<N, Set<N>>();
    protected Set<N> nodeIDs = Collections.unmodifiableSet(this.nodeLinks.keySet());

    public void add(N n) {
        if (this.nodeLinks.containsKey(n)) {
            return;
        }
        this.nodeLinks.put(n, new ArraySet());
    }

    public void connect(N n, N n2) throws NullPointerException {
        this.nodeLinks.get(n).add(n2);
        this.nodeLinks.get(n2).add(n);
    }

    public void disconnect(N n, N n2) throws NullPointerException {
        this.nodeLinks.get(n).remove(n2);
        this.nodeLinks.get(n2).remove(n);
    }

    public Set<N> getConnectedNodesFor(N n) throws NullPointerException {
        return Collections.unmodifiableSet(this.nodeLinks.get(n));
    }

    public Set<N> getNodes() {
        return this.nodeIDs;
    }

    public void remove(N n) {
        if (!this.nodeLinks.containsKey(n)) {
            return;
        }
        for (N n2 : this.nodeLinks.get(n)) {
            this.nodeLinks.get(n2).remove(n);
        }
        this.nodeLinks.get(n).clear();
        this.nodeLinks.remove(n);
    }
}

