/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import java.util.logging.Logger;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

public abstract class VolumetricSpace {
    protected static final Logger logger = Logger.getLogger(VolumetricSpace.class.getName());
    public final int resX;
    public final int resY;
    public final int resZ;
    public final int resX1;
    public final int resY1;
    public final int resZ1;
    public final int sliceRes;
    public final Vec3D scale = new Vec3D();
    public final Vec3D halfScale = new Vec3D();
    public final Vec3D voxelSize = new Vec3D();
    public final int numCells;

    public VolumetricSpace(Vec3D vec3D, int n, int n2, int n3) {
        this.resX = n;
        this.resY = n2;
        this.resZ = n3;
        this.resX1 = n - 1;
        this.resY1 = n2 - 1;
        this.resZ1 = n3 - 1;
        this.sliceRes = n * n2;
        this.numCells = this.sliceRes * n3;
        this.setScale(vec3D);
        logger.info("new space of " + n + "x" + n2 + "x" + n3 + " cells: " + this.numCells);
    }

    public abstract void clear();

    public void closeSides() {
        throw new UnsupportedOperationException("This VolumetricSpace implementation does not support closeSides()");
    }

    public final int getIndexFor(int n, int n2, int n3) {
        n = MathUtils.clip((int)n, (int)0, (int)this.resX1);
        n2 = MathUtils.clip((int)n2, (int)0, (int)this.resY1);
        n3 = MathUtils.clip((int)n3, (int)0, (int)this.resZ1);
        return n + n2 * this.resX + n3 * this.sliceRes;
    }

    public final Vec3D getResolution() {
        return new Vec3D((float)this.resX, (float)this.resY, (float)this.resZ);
    }

    public final Vec3D getScale() {
        return this.scale.copy();
    }

    public abstract float getVoxelAt(int var1);

    public final void setScale(Vec3D vec3D) {
        this.scale.set(vec3D);
        this.halfScale.set(vec3D.scale(0.5f));
        this.voxelSize.set(vec3D.x / (float)this.resX, vec3D.y / (float)this.resY, vec3D.z / (float)this.resZ);
    }

    public void setVoxelAt(int n, float f) {
        throw new UnsupportedOperationException("This VolumetricSpace implementation does not support setVoxelAt()");
    }

    public void setVoxelAt(int n, int n2, int n3, float f) {
        throw new UnsupportedOperationException("This VolumetricSpace implementation does not support setVoxelAt()");
    }
}

