/*
 * Decompiled with CFR 0.152.
 */
package toxi.volume;

import toxi.geom.AABB;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Triangle3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Face;
import toxi.geom.mesh.Mesh3D;
import toxi.math.MathUtils;
import toxi.math.ScaleMap;
import toxi.volume.VolumetricHashMap;
import toxi.volume.VolumetricSpace;
import toxi.volume.VolumetricSpaceArray;

public class MeshVoxelizer {
    protected VolumetricSpace volume;
    protected int wallThickness = 0;

    public MeshVoxelizer(int n) {
        this(n, n, n);
    }

    public MeshVoxelizer(int n, int n2, int n3) {
        this.volume = new VolumetricHashMap(new Vec3D(1.0f, 1.0f, 1.0f), n, n2, n3, 0.1f);
    }

    public MeshVoxelizer clear() {
        this.volume.clear();
        return this;
    }

    public VolumetricSpace getVolume() {
        return this.volume;
    }

    public int getWallThickness() {
        return this.wallThickness;
    }

    protected void setVoxelAt(int n, int n2, int n3, float f) {
        int n4 = MathUtils.max((int)(n - this.wallThickness), (int)0);
        int n5 = MathUtils.max((int)(n2 - this.wallThickness), (int)0);
        int n6 = MathUtils.max((int)(n3 - this.wallThickness), (int)0);
        int n7 = MathUtils.min((int)(n + this.wallThickness), (int)this.volume.resX1);
        int n8 = MathUtils.min((int)(n2 + this.wallThickness), (int)this.volume.resY1);
        int n9 = MathUtils.min((int)(n3 + this.wallThickness), (int)this.volume.resZ1);
        for (n3 = n6; n3 <= n9; ++n3) {
            for (n2 = n5; n2 <= n8; ++n2) {
                for (n = n4; n <= n7; ++n) {
                    this.volume.setVoxelAt(n, n2, n3, f);
                }
            }
        }
    }

    public MeshVoxelizer setWallThickness(int n) {
        this.wallThickness = n;
        return this;
    }

    private VolumetricSpace solidifyVolume(VolumetricSpaceArray volumetricSpaceArray) {
        for (int i = 0; i < volumetricSpaceArray.resZ; ++i) {
            for (int j = 0; j < volumetricSpaceArray.resY; ++j) {
                boolean bl = false;
                int n = 0;
                for (int k = 0; k < volumetricSpaceArray.resX; ++k) {
                    float f = volumetricSpaceArray.getVoxelAt(k, j, i);
                    if (!(f > 0.0f)) continue;
                    if (!bl) {
                        n = k;
                        bl = true;
                        continue;
                    }
                    for (int i2 = n; i2 <= k; ++i2) {
                        volumetricSpaceArray.setVoxelAt(i2, j, i, 1.0f);
                    }
                    bl = false;
                }
            }
        }
        return volumetricSpaceArray;
    }

    public VolumetricSpace voxelizeMesh(Mesh3D mesh3D) {
        return this.voxelizeMesh(mesh3D, 1.0f);
    }

    public VolumetricSpace voxelizeMesh(Mesh3D mesh3D, float f) {
        AABB aABB = mesh3D.getBoundingBox();
        Vec3D vec3D = aABB.getMin();
        Vec3D vec3D2 = aABB.getMax();
        ScaleMap scaleMap = new ScaleMap((double)vec3D.x, (double)vec3D2.x, 1.0, (double)(this.volume.resX - 2));
        ScaleMap scaleMap2 = new ScaleMap((double)vec3D.y, (double)vec3D2.y, 1.0, (double)(this.volume.resY - 2));
        ScaleMap scaleMap3 = new ScaleMap((double)vec3D.z, (double)vec3D2.z, 1.0, (double)(this.volume.resZ - 2));
        ScaleMap scaleMap4 = new ScaleMap(1.0, (double)(this.volume.resX - 2), (double)vec3D.x, (double)vec3D2.x);
        ScaleMap scaleMap5 = new ScaleMap(1.0, (double)(this.volume.resY - 2), (double)vec3D.y, (double)vec3D2.y);
        ScaleMap scaleMap6 = new ScaleMap(1.0, (double)(this.volume.resZ - 2), (double)vec3D.z, (double)vec3D2.z);
        this.volume.setScale(aABB.getExtent().scale(2.0f));
        Triangle3D triangle3D = new Triangle3D();
        AABB aABB2 = new AABB((ReadonlyVec3D)new Vec3D(), (ReadonlyVec3D)this.volume.voxelSize.scale(0.5f));
        for (Face face : mesh3D.getFaces()) {
            triangle3D.a = face.a;
            triangle3D.b = face.b;
            triangle3D.c = face.c;
            AABB aABB3 = triangle3D.getBoundingBox();
            Vec3D vec3D3 = aABB3.getMin();
            Vec3D vec3D4 = aABB3.getMax();
            vec3D3 = new Vec3D((float)((int)scaleMap.getClippedValueFor((double)vec3D3.x)), (float)((int)scaleMap2.getClippedValueFor((double)vec3D3.y)), (float)((int)scaleMap3.getClippedValueFor((double)vec3D3.z)));
            vec3D4 = new Vec3D((float)((int)scaleMap.getClippedValueFor((double)vec3D4.x)), (float)((int)scaleMap2.getClippedValueFor((double)vec3D4.y)), (float)((int)scaleMap3.getClippedValueFor((double)vec3D4.z)));
            int n = (int)vec3D3.z;
            while ((float)n <= vec3D4.z) {
                int n2 = (int)vec3D3.y;
                while ((float)n2 <= vec3D4.y) {
                    int n3 = (int)vec3D3.x;
                    while ((float)n3 <= vec3D4.x) {
                        if (n3 < this.volume.resX1 && n2 < this.volume.resY1 && n < this.volume.resZ1) {
                            aABB2.set((float)scaleMap4.getClippedValueFor((double)n3), (float)scaleMap5.getClippedValueFor((double)n2), (float)scaleMap6.getClippedValueFor((double)n));
                            if (aABB2.intersectsTriangle(triangle3D)) {
                                this.setVoxelAt(n3, n2, n, f);
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return this.volume;
    }
}

