/*
 * Decompiled with CFR 0.152.
 */
package toxi.music.scale;

import toxi.math.MathUtils;

public abstract class AbstractScale {
    public static final int OCTAVE_RANGE = 2;
    public static final float HALFTONE_STEP = (float)Math.pow(2.0, 0.08333333333333333);
    public static final float INV_HALFTONE = 0.083333336f;
    public byte[] tones;
    protected String name;

    public AbstractScale(String string, byte[] byArray) {
        this.name = string;
        this.tones = byArray;
    }

    public String getName() {
        return this.name;
    }

    public float getPitchForScaleTone(int n) {
        return this.getPitchForScaleTone(n, this.tones.length, 0);
    }

    public float getPitchForScaleTone(int n, int n2, int n3) {
        n2 = MathUtils.min((int)n2, (int)this.tones.length);
        int n4 = n / n2;
        if ((n %= n2) < 0) {
            n += n2;
            --n4;
        }
        return (float)Math.pow(2.0, (double)(n4 * 12 + this.tones[n] + n3) / 12.0);
    }

    public float getPitchForSemitone(int n) {
        return (float)Math.pow(2.0, (double)n / 12.0);
    }
}

