/*
 * Decompiled with CFR 0.152.
 */
package toxi.music;

import toxi.music.QuantizedTimeHandler;
import toxi.util.events.EventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuantizedTimeProvider
extends Thread {
    protected long previousTime;
    protected boolean isActive = true;
    protected double interval;
    protected double bpm;
    protected double targetBPM;
    protected double tempoChangeSpeed = 0.01;
    protected int ticks = 0;
    protected int ticksPerBeat;
    protected int ticksPerBar;
    protected int beatsPerBar;
    protected final EventDispatcher<QuantizedTimeHandler> dispatcher = new EventDispatcher();

    public QuantizedTimeProvider(double d, int n, int n2) {
        this.bpm = d;
        this.targetBPM = d;
        this.beatsPerBar = n;
        this.ticksPerBeat = n2;
        this.updateTicksPerBar();
        this.interval = 1000.0 / (d / 60.0) / (double)this.ticksPerBeat;
        this.previousTime = System.nanoTime();
    }

    public int getBeatsPerBar() {
        return this.beatsPerBar;
    }

    public EventDispatcher<QuantizedTimeHandler> getDispatcher() {
        return this.dispatcher;
    }

    public double getTargetTempo() {
        return this.targetBPM;
    }

    public double getTempo() {
        return this.bpm;
    }

    public double getTempoChangeSpeed() {
        return this.tempoChangeSpeed;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getTicksPerBar() {
        return this.ticksPerBar;
    }

    public int getTicksPerBeat() {
        return this.ticksPerBeat;
    }

    public void makeHighPriority() {
        this.setPriority(7);
    }

    @Override
    public void run() {
        try {
            while (this.isActive) {
                int n;
                double d = (double)(System.nanoTime() - this.previousTime) * 1.0E-6;
                while (d < this.interval) {
                    d = (double)(System.nanoTime() - this.previousTime) * 1.0E-6;
                }
                if (0 == this.ticks % this.ticksPerBar) {
                    n = this.ticks / this.ticksPerBar;
                    for (QuantizedTimeHandler quantizedTimeHandler : this.dispatcher) {
                        quantizedTimeHandler.handleBar(n);
                    }
                }
                if (0 == this.ticks % this.ticksPerBeat) {
                    n = this.ticks / this.ticksPerBeat;
                    for (QuantizedTimeHandler quantizedTimeHandler : this.dispatcher) {
                        quantizedTimeHandler.handleBeat(n);
                    }
                }
                for (Object object : this.dispatcher) {
                    object.handleTick(this.ticks);
                }
                ++this.ticks;
                this.bpm += (this.targetBPM - this.bpm) * this.tempoChangeSpeed;
                this.setTempo((float)this.bpm);
                long l = (long)(this.interval - (double)(System.nanoTime() - this.previousTime) * 1.0E-6);
                this.previousTime = System.nanoTime();
                if (l <= 0L) continue;
                Thread.sleep(l);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setBeatsPerBar(int n) {
        this.beatsPerBar = n;
        this.updateTicksPerBar();
    }

    public void setTargetTempo(double d) {
        this.targetBPM = d;
    }

    public void setTempo(double d) {
        this.bpm = d;
        this.interval = 1000.0 / (d / 60.0) / (double)this.ticksPerBeat;
    }

    public void setTempoChangeSpeed(double d) {
        this.tempoChangeSpeed = d;
    }

    public void setTicksPerBeat(int n) {
        this.ticksPerBeat = n;
        this.updateTicksPerBar();
    }

    protected void updateTicksPerBar() {
        this.ticksPerBar = this.beatsPerBar * this.ticksPerBeat;
    }
}

