/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import net.java.games.joal.AL;
import toxi.audio.AudioBuffer;
import toxi.geom.Vec3D;
import toxi.math.MathUtils;

public class AudioSource
extends Vec3D {
    protected AL al;
    protected AudioBuffer buffer;
    protected final int id;
    protected int size;
    protected final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected final float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    protected final float[] direction = new float[]{0.0f, 0.0f, 0.0f};
    protected int[] alResult = new int[1];
    protected boolean isLooping;

    public AudioSource(AL aL, int n) {
        this(aL, n, null);
    }

    public AudioSource(AL aL, int n, AudioBuffer audioBuffer) {
        this.al = aL;
        this.id = n;
        this.setBuffer(audioBuffer);
    }

    public boolean delete() {
        this.stop();
        this.setBuffer(null);
        this.al.alDeleteSources(1, new int[]{this.id}, 0);
        return this.al.alGetError() == 0;
    }

    public AudioBuffer getBuffer() {
        return this.buffer;
    }

    public int getBuffersProcessed() {
        this.al.alGetSourcei(this.id, 4118, this.alResult, 0);
        return this.alResult[0];
    }

    public final float[] getDirection() {
        return this.direction;
    }

    public final int getID() {
        return this.id;
    }

    public final int getOffset() {
        this.al.alGetSourcei(this.id, 4133, this.alResult, 0);
        return this.alResult[0];
    }

    public final float[] getPosition() {
        return this.position;
    }

    public final float[] getVelocity() {
        return this.velocity;
    }

    public final boolean isLooping() {
        return this.isLooping;
    }

    public final int length() {
        return this.size;
    }

    public AudioSource play() {
        if (this.buffer != null) {
            this.al.alSourcePlay(this.id);
        }
        return this;
    }

    public AudioSource rewind() {
        if (this.buffer != null) {
            this.al.alSourceRewind(this.id);
        }
        return this;
    }

    public AudioSource setBuffer(AudioBuffer audioBuffer) {
        this.buffer = audioBuffer;
        if (audioBuffer != null) {
            this.al.alSourcei(this.id, 4105, audioBuffer.getID());
            this.size = audioBuffer.getSampleSize();
        } else {
            this.al.alSourcei(this.id, 4105, 0);
            this.size = 0;
        }
        return this;
    }

    public AudioSource setDirection(float f, float f2, float f3) {
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
        this.al.alSourcefv(this.id, 4101, this.direction, 0);
        return this;
    }

    public AudioSource setDirection(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("wrong number of array elements");
        }
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
        this.al.alSourcefv(this.id, 4101, this.direction, 0);
        return this;
    }

    public AudioSource setDirection(Vec3D vec3D) {
        return this.setDirection(vec3D.x, vec3D.y, vec3D.z);
    }

    public AudioSource setGain(float f) {
        this.al.alSourcef(this.id, 4106, f);
        return this;
    }

    public AudioSource setLooping(boolean bl) {
        this.isLooping = bl;
        this.al.alSourcei(this.id, 4103, bl ? 1 : 0);
        return this;
    }

    public AudioSource setOffset(int n) {
        n = MathUtils.clip((int)n, (int)0, (int)(this.size - 1));
        this.al.alSourcei(this.id, 4133, n);
        return this;
    }

    public AudioSource setPitch(float f) {
        this.al.alSourcef(this.id, 4099, f);
        return this;
    }

    public AudioSource setPosition(float f, float f2, float f3) {
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
        this.al.alSourcefv(this.id, 4100, this.position, 0);
        return this;
    }

    public AudioSource setPosition(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("wrong number of array elements");
        }
        this.x = this.position[0] = fArray[0];
        this.y = this.position[1] = fArray[1];
        this.z = this.position[2] = fArray[2];
        this.al.alSourcefv(this.id, 4100, this.position, 0);
        return this;
    }

    public AudioSource setPosition(Vec3D vec3D) {
        return this.setPosition(vec3D.x, vec3D.y, vec3D.z);
    }

    public AudioSource setReferenceDistance(float f) {
        this.al.alSourcef(this.id, 4128, f);
        return this;
    }

    public AudioSource setVelocity(float f, float f2, float f3) {
        this.velocity[0] = f;
        this.velocity[1] = f2;
        this.velocity[2] = f3;
        this.al.alSourcefv(this.id, 4102, this.velocity, 0);
        return this;
    }

    public AudioSource setVelocity(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("wrong number of array elements");
        }
        this.velocity[0] = fArray[0];
        this.velocity[1] = fArray[1];
        this.velocity[2] = fArray[2];
        this.al.alSourcefv(this.id, 4102, this.velocity, 0);
        return this;
    }

    public AudioSource setVelocity(Vec3D vec3D) {
        return this.setVelocity(vec3D.x, vec3D.y, vec3D.z);
    }

    public AudioSource stop() {
        this.al.alSourceStop(this.id);
        return this;
    }

    public String toString() {
        return "AudioSource: id=" + this.id + (this.buffer != null ? " buffer=" + this.buffer.toString() : "");
    }

    public AudioSource updatePosition() {
        this.position[0] = this.x;
        this.position[1] = this.y;
        this.position[2] = this.z;
        this.al.alSourcefv(this.id, 4100, this.position, 0);
        return this;
    }
}

