/*
 * Decompiled with CFR 0.152.
 */
package toxi.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.java.games.joal.AL;
import toxi.audio.DecompressInputStream;

public class AudioBuffer {
    protected final AL al;
    protected ByteBuffer data;
    protected final int id;
    protected final int[] alResult = new int[1];
    protected Format format;

    public AudioBuffer(AL aL, int n) {
        this.id = n;
        this.al = aL;
    }

    public AudioBuffer configure(ByteBuffer byteBuffer, Format format, int n) {
        return this.configure(byteBuffer, format.getID(), n);
    }

    public AudioBuffer configure(ByteBuffer byteBuffer, int n, int n2) {
        this.data = byteBuffer;
        this.format = Format.getForID(n);
        this.al.alBufferData(this.id, n, (Buffer)byteBuffer, byteBuffer.capacity(), n2);
        return this;
    }

    public boolean convertUlawToPCM(boolean bl) {
        byte[] byArray = new byte[this.getByteSize()];
        this.data.rewind();
        this.data.get(byArray);
        byte[] byArray2 = new byte[byArray.length * 2];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            new DecompressInputStream(byteArrayInputStream, bl).read(byArray2);
            this.configure(ByteBuffer.wrap(byArray2), Format.MONO16, this.getFrequency());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean delete() {
        this.data = null;
        this.al.alDeleteBuffers(1, new int[]{this.id}, 0);
        return this.al.alGetError() == 0;
    }

    public final int getBitDepth() {
        return this.format.getNumBits();
    }

    public final int getByteSize() {
        return this.data.capacity();
    }

    public final ByteBuffer getData() {
        return this.data;
    }

    public final int getFrequency() {
        this.al.alGetBufferi(this.id, 8193, this.alResult, 0);
        return this.alResult[0];
    }

    public final int getID() {
        return this.id;
    }

    public final int getNumChannels() {
        return this.format.getNumChannels();
    }

    public final int getSampleSize() {
        return this.getByteSize() * 8 / this.getBitDepth() / this.getNumChannels();
    }

    public String toString() {
        return "AudioBuffer: id=" + this.id + " format=" + (Object)((Object)this.format);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        MONO8(4352, 8, 1),
        MONO16(4353, 16, 1),
        STEREO8(4354, 8, 2),
        STEREO16(4355, 16, 2);

        private final int id;
        private final int numBits;
        private final int numChannels;

        public static Format getForID(int n) {
            Format format = null;
            for (Format format2 : Format.values()) {
                if (format2.id != n) continue;
                format = format2;
                break;
            }
            return format;
        }

        private Format(int n2, int n3, int n4) {
            this.id = n2;
            this.numBits = n3;
            this.numChannels = n4;
        }

        public int getID() {
            return this.id;
        }

        public int getNumBits() {
            return this.numBits;
        }

        public int getNumChannels() {
            return this.numChannels;
        }
    }
}

