/*
 * Decompiled with CFR 0.152.
 */
package toxi.sim.automata;

import java.util.ArrayList;
import toxi.math.MathUtils;
import toxi.sim.automata.CARule;
import toxi.sim.automata.EvolvableMatrix;

public class CARule2D
implements CARule {
    protected boolean[] survivalRules;
    protected boolean[] birthRules = new boolean[9];
    protected int stateCount;
    protected float randomBirthChance = 0.15f;
    protected float randomSurvivalChance = 0.25f;
    protected boolean isTiling;
    protected boolean isAutoExpire;

    public CARule2D(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        this.setBirthRules(byArray);
        this.survivalRules = new boolean[9];
        this.setSurvivalRules(byArray2);
        this.stateCount = MathUtils.max((int)1, (int)n);
        this.setTiling(bl);
    }

    public void evolve(EvolvableMatrix evolvableMatrix) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = evolvableMatrix.getWidth();
        int n6 = evolvableMatrix.getHeight();
        int[] nArray = evolvableMatrix.getMatrix();
        int[] nArray2 = evolvableMatrix.getSwapBuffer();
        int n7 = this.stateCount - 1;
        if (this.isTiling) {
            n4 = 0;
            n3 = n5;
            n2 = 0;
            n = n6;
        } else {
            n4 = 1;
            n3 = n5 - 1;
            n2 = 1;
            n = n6 - 1;
        }
        for (int i = n2; i < n; ++i) {
            int n8 = (i > 0 ? i - 1 : n6 - 1) * n5;
            int n9 = (i < n6 - 1 ? i + 1 : 0) * n5;
            int n10 = i * n5;
            for (int j = n4; j < n3; ++j) {
                int n11;
                int n12 = j > 0 ? j - 1 : n5 - 1;
                int n13 = j < n5 - 1 ? j + 1 : 0;
                int n14 = n11 = nArray[n10 + j];
                int n15 = 0;
                if (n11 > 1) {
                    n14 = this.isAutoExpire ? (n14 + 1) % this.stateCount : MathUtils.min((int)(n14 + 1), (int)n7);
                } else {
                    if (nArray[n8 + n12] == 1) {
                        ++n15;
                    }
                    if (nArray[n8 + j] == 1) {
                        ++n15;
                    }
                    if (nArray[n8 + n13] == 1) {
                        ++n15;
                    }
                    if (nArray[n10 + n12] == 1) {
                        ++n15;
                    }
                    if (nArray[n10 + n13] == 1) {
                        ++n15;
                    }
                    if (nArray[n9 + n12] == 1) {
                        ++n15;
                    }
                    if (nArray[n9 + j] == 1) {
                        ++n15;
                    }
                    if (nArray[n9 + n13] == 1) {
                        ++n15;
                    }
                    if (n11 != 0) {
                        n14 = this.survivalRules[n15] ? 1 : (this.isAutoExpire ? (n14 + 1) % this.stateCount : MathUtils.min((int)(n14 + 1), (int)n7));
                    } else if (this.birthRules[n15]) {
                        n14 = 1;
                    }
                }
                nArray2[n10 + j] = n14;
            }
        }
    }

    public int getStateCount() {
        return this.stateCount;
    }

    public boolean isAutoExpire() {
        return this.isAutoExpire;
    }

    public boolean isTiling() {
        return this.isTiling;
    }

    protected byte[] randomArray(double d) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (byte by = 0; by < 9; by = (byte)(by + 1)) {
            if (!(Math.random() < d)) continue;
            arrayList.add(by);
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        return byArray;
    }

    public void randomize() {
        this.setRuleArray(this.randomArray(this.randomBirthChance), this.birthRules);
        this.setRuleArray(this.randomArray(this.randomSurvivalChance), this.survivalRules);
    }

    public void setAutoExpire(boolean bl) {
        this.isAutoExpire = bl;
    }

    public void setBirthRules(byte[] byArray) {
        this.setRuleArray(byArray, this.birthRules);
    }

    public void setRandomProbabilities(float f, float f2) {
        this.randomBirthChance = f;
        this.randomSurvivalChance = f2;
    }

    protected void setRuleArray(byte[] byArray, boolean[] blArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by < 0 || by >= blArray.length) {
                throw new ArrayIndexOutOfBoundsException("invalid rule index: " + by + " (needs to be less than 9 for a 3x3 kernel");
            }
            blArray[by] = true;
        }
    }

    public void setStateCount(int n) {
        this.stateCount = n;
    }

    public void setSurvivalRules(byte[] byArray) {
        this.setRuleArray(byArray, this.survivalRules);
    }

    public void setTiling(boolean bl) {
        this.isTiling = bl;
    }
}

