/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange {
    @XmlAttribute
    public int min;
    @XmlAttribute
    public int max;
    @XmlAttribute(name="default")
    public int currValue;
    protected Random random = new Random();

    public static IntegerRange fromSamples(List<Integer> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int n3 : list) {
            n = MathUtils.min(n, n3);
            n2 = MathUtils.max(n2, n3);
        }
        return new IntegerRange(n, n2);
    }

    public IntegerRange() {
        this(0, 100);
    }

    public IntegerRange(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.currValue = n;
    }

    public int adjustCurrentBy(int n) {
        return this.setCurrent(this.currValue + n);
    }

    public IntegerRange copy() {
        IntegerRange integerRange = new IntegerRange(this.min, this.max);
        integerRange.currValue = this.currValue;
        integerRange.random = this.random;
        return integerRange;
    }

    public int getCurrent() {
        return this.currValue;
    }

    public int getMedian() {
        return (this.min + this.max) / 2;
    }

    public boolean isValueInRange(int n) {
        return n >= this.min && n < this.max;
    }

    public int pickRandom() {
        this.currValue = MathUtils.random(this.random, this.min, this.max);
        return this.currValue;
    }

    public IntegerRange seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public int setCurrent(int n) {
        this.currValue = MathUtils.clip(n, this.min, this.max);
        return this.currValue;
    }

    public IntegerRange setRandom(Random random) {
        this.random = random;
        return this;
    }

    public Integer[] toArray() {
        Integer[] integerArray = new Integer[this.max - this.min];
        int n = 0;
        for (int i = this.min; i < this.max; ++i) {
            integerArray[n] = i;
            ++n;
        }
        return integerArray;
    }

    public String toString() {
        return "IntegerRange: " + this.min + " -> " + this.max;
    }
}

