/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.mesh.STLColorModel;

public class MaterialiseSTLColorModel
implements STLColorModel {
    protected int baseColor;
    protected boolean useFacetColors;

    public MaterialiseSTLColorModel(int n) {
        this(n, false);
    }

    public MaterialiseSTLColorModel(int n, boolean bl) {
        this.baseColor = n;
        this.useFacetColors = bl;
    }

    public void enableFacetColors(boolean bl) {
        this.useFacetColors = bl;
    }

    public boolean facetColorsEnabled() {
        return this.useFacetColors;
    }

    public void formatHeader(byte[] byArray) {
        char[] cArray = new char[]{'C', 'O', 'L', 'O', 'R', '='};
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        byArray[6] = (byte)(this.baseColor >> 16 & 0xFF);
        byArray[7] = (byte)(this.baseColor >> 8 & 0xFF);
        byArray[8] = (byte)(this.baseColor & 0xFF);
        byArray[9] = (byte)(this.baseColor >>> 24);
    }

    public int formatRGB(int n) {
        int n2 = n >> 19 & 0x1F;
        n2 |= (n >> 11 & 0x1F) << 5;
        n2 |= (n >> 3 & 0x1F) << 10;
        if (!this.useFacetColors) {
            n2 |= 0x8000;
        }
        return n2;
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public int getDefaultRGB() {
        return 32768;
    }

    public void setBaseColor(int n) {
        this.baseColor = n;
    }
}

