/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;

public class BezierPatch {
    public Vec3D[][] points;

    public static Vec3D computePointAt(float f, float f2, Vec3D[][] vec3DArray) {
        float f3 = 1.0f - f;
        float f4 = f3 * f3 * 3.0f * f;
        float f5 = f3 * f3 * f3;
        float f6 = f * f;
        float f7 = 1.0f - f2;
        float f8 = f2 * f2 * 3.0f;
        float f9 = f7 * f7 * 3.0f;
        float f10 = f7 * f7 * f7;
        float f11 = f2 * f2 * f2;
        float f12 = f3 * f6 * 3.0f;
        float f13 = f * f6;
        float f14 = f7 * f8;
        float f15 = f9 * f2;
        Vec3D[] vec3DArray2 = vec3DArray[0];
        Vec3D[] vec3DArray3 = vec3DArray[1];
        Vec3D[] vec3DArray4 = vec3DArray[2];
        Vec3D[] vec3DArray5 = vec3DArray[3];
        float f16 = f5 * (vec3DArray2[0].x * f10 + vec3DArray2[1].x * f15 + vec3DArray2[2].x * f14 + vec3DArray2[3].x * f11) + f4 * (vec3DArray3[0].x * f10 + vec3DArray3[1].x * f15 + vec3DArray3[2].x * f14 + vec3DArray3[3].x * f11) + f12 * (vec3DArray4[0].x * f10 + vec3DArray4[1].x * f15 + vec3DArray4[2].x * f14 + vec3DArray4[3].x * f11) + f13 * (vec3DArray5[0].x * f10 + vec3DArray5[1].x * f15 + vec3DArray5[2].x * f14 + vec3DArray5[3].x * f11);
        float f17 = f5 * (vec3DArray2[0].y * f10 + vec3DArray2[1].y * f15 + vec3DArray2[2].y * f14 + vec3DArray2[3].y * f11) + f4 * (vec3DArray3[0].y * f10 + vec3DArray3[1].y * f15 + vec3DArray3[2].y * f14 + vec3DArray3[3].y * f11) + f12 * (vec3DArray4[0].y * f10 + vec3DArray4[1].y * f15 + vec3DArray4[2].y * f14 + vec3DArray4[3].y * f11) + f13 * (vec3DArray5[0].y * f10 + vec3DArray5[1].y * f15 + vec3DArray5[2].y * f14 + vec3DArray5[3].y * f11);
        float f18 = f5 * (vec3DArray2[0].z * f10 + vec3DArray2[1].z * f15 + vec3DArray2[2].z * f14 + vec3DArray2[3].z * f11) + f4 * (vec3DArray3[0].z * f10 + vec3DArray3[1].z * f15 + vec3DArray3[2].z * f14 + vec3DArray3[3].z * f11) + f12 * (vec3DArray4[0].z * f10 + vec3DArray4[1].z * f15 + vec3DArray4[2].z * f14 + vec3DArray4[3].z * f11) + f13 * (vec3DArray5[0].z * f10 + vec3DArray5[1].z * f15 + vec3DArray5[2].z * f14 + vec3DArray5[3].z * f11);
        return new Vec3D(f16, f17, f18);
    }

    public BezierPatch() {
        this.points = new Vec3D[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.points[i][j] = new Vec3D();
            }
        }
    }

    public BezierPatch(Vec3D[][] vec3DArray) {
        this.points = vec3DArray;
    }

    public Vec3D computePointAt(float f, float f2) {
        return BezierPatch.computePointAt(f, f2, this.points);
    }

    public BezierPatch set(int n, int n2, Vec3D vec3D) {
        this.points[n2][n].set(vec3D);
        return this;
    }

    public Mesh3D toMesh(int n) {
        return this.toMesh(null, n);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, int n) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh();
        }
        Vec3D[] vec3DArray = new Vec3D[n + 1];
        Vec3D[] vec3DArray2 = new Vec3D[n + 1];
        float f = 1.0f / (float)n;
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n; ++j) {
                Vec3D vec3D = BezierPatch.computePointAt((float)j * f, (float)i * f, this.points);
                if (j > 0 && i > 0) {
                    mesh3D.addFace(vec3D, vec3DArray[j - 1], vec3DArray2[j - 1]);
                    mesh3D.addFace(vec3D, vec3DArray2[j - 1], vec3DArray2[j]);
                }
                vec3DArray[j] = vec3D;
            }
            Vec3D[] vec3DArray3 = vec3DArray2;
            vec3DArray2 = vec3DArray;
            vec3DArray = vec3DArray3;
        }
        return mesh3D;
    }
}

