/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Cone;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Shape3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;

public abstract class AxisAlignedCylinder
implements Shape3D {
    protected Vec3D pos;
    protected float radius;
    protected float radiusSquared;
    protected float length;

    protected AxisAlignedCylinder(ReadonlyVec3D readonlyVec3D, float f, float f2) {
        this.pos = readonlyVec3D.copy();
        this.setRadius(f);
        this.setLength(f2);
    }

    public abstract boolean containsPoint(ReadonlyVec3D var1);

    public float getLength() {
        return this.length;
    }

    public abstract Vec3D.Axis getMajorAxis();

    public Vec3D getPosition() {
        return this.pos.copy();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public void setPosition(Vec3D vec3D) {
        this.pos.set(vec3D);
    }

    public void setRadius(float f) {
        this.radius = f;
        this.radiusSquared = f * f;
    }

    public Mesh3D toMesh() {
        return this.toMesh(12, 0.0f);
    }

    public Mesh3D toMesh(int n, float f) {
        return this.toMesh(null, n, f);
    }

    public Mesh3D toMesh(Mesh3D mesh3D, int n, float f) {
        return new Cone(this.pos, this.getMajorAxis().getVector(), this.radius, this.radius, this.length).toMesh(mesh3D, n, f, true, true);
    }
}

